﻿using System;
using System.Collections;
using System.Configuration;
using System.Data;
using System.Linq;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Xml.Linq;
using VeteransAffairs.Registries.Business;
using VeteransAffairs.Registries.BusinessManager;
using VeteransAffairs.Registries.BusinessManager.Utilities;
using VeteransAffairs.Registries.BusinessManager.TBI;
using System.Text;
using AntiXssEnc = Microsoft.Security.Application;

public partial class PolyTraumaEntry : BasePage {
    TBI_POLYTRAUMA polyTraumEntry;
    PolyTraumaEntriesManager PolyTraumaManager = new PolyTraumaEntriesManager();
    //TBIExceptionHandler _tbiexception = new TBIExceptionHandler();

    bool blnDischargeToEditMode = false;
    private int? _intOriginalTbiDischargetoCode;

    #region Public Methods

    public PolyTraumaEntry() {
        //Manager Save Notification Event Handler
        PolyTraumaManager.BOSaveSuccess += new BaseBO.BOSaveSuccessEvent(manager_BOSaveSuccess);
    }
    public override string TopMenuName() {
        return "My Tasks";
    }
    public override string MenuItemName() {
        return "TBI POLYTRAUMA";
    }
    public override string AppObjectCode() {
        return "TBI POLYTRAUMA";
    }

    #endregion Public Methods

    #region Protected Methods

    /// <summary>
    /// Page_Load Event.
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void Page_Load(object sender, EventArgs e) {
        if (!IsPostBack) {
            try {
                //if page is loading for first time get ID from querystring and set to hidden field to use on postbacks
                int? entryID = 0;
                if (Request.QueryString["id"] != null) {
                    entryID = Convert.ToInt32(Request.QueryString["id"].ToString());
                }
                HiddenFieldEntryID.Value = entryID.GetValueOrDefault().ToString();

                //Check if the request is to start a new item a new item page request is signified when the querystring parameter id equals zero or is not present
                if (entryID == null || entryID == 0) {
                    //set entryID to zero so that a default linq entity will be instantiated
                    entryID = 0;

                    if (this.AllowInsert) {
                        //if a new item then set patient search to true and hide all others
                        SetFormToNewPatientSearchMode();
                    } else {
                        SetFormToNoInsertAllowedMode();
                    }
                } else {
                    //Modify breadcrumb to display editing ID
                    SetBreadCrumbLabelText(entryID);
                }
            } catch (Exception _ex) {
                Logging.WriteLogToFile("PolyTraumaEntry Page_Load exception: " + _ex.ToString());
            }
        }


        //Create PolyTrauma Entity object and Set properties to state of form
        if (HiddenFieldEntryID.Value != null) {
            getEntry(Convert.ToInt32(HiddenFieldEntryID.Value));
        }

        CompareValidatorDeathPastDaste.ValueToCompare = DateTime.Now.ToShortDateString();
        CompareValidatorRehabAdmitDateCurrentDate.ValueToCompare = DateTime.Now.ToShortDateString();
        HiddenFieldCurrentDate.Value = DateTime.Now.ToShortDateString();

        if (IsPostBack) {
            LoadObjectFromControls();
        }

    }

    protected void getEntry(int id) {
        try {
            polyTraumEntry = PolyTraumaManager.SelectByID(id);

            //initial display panels
            PanelNoAccess.Visible = false;
            PanelIdNotFound.Visible = false;
            PanelObjectContent.Visible = false;

            if (polyTraumEntry == null) {
                PanelObjectContent.Visible = false;

                if (PolyTraumaManager.PolyTraumaExists(id)) {
                    PanelNoAccess.Visible = true;
                } else {
                    PanelIdNotFound.Visible = true;
                }
            } else {
                if (id != 0) {
                    EntityInstitution = polyTraumEntry.POLYTRAUMA_CENTER_ID;
                }
                PanelObjectContent.Visible = true;
            }
        } catch (Exception _ex) {
            Logging.WriteLogToFile("PolyTraumaEntry.getEntry(id): exception: " + _ex.ToString());
            //_tbiexception.HandleTBIException(_ex, "PolyTraumaEntry", "1000033", "getEntry()");
        }
    }

    /// <summary>
    /// Close button handler for PRC area.
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void ButtonClose_Click(object sender, EventArgs e) {
        Response.Redirect("PolyTraumaEntries.aspx");
    }

    /// <summary>
    /// Close button handler for PTRP
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void btnPTRPClose_Click(object sender, EventArgs e) {
        Response.Redirect("PolyTraumaEntries.aspx");
    }

    protected void ButtonSearchPatient_Click(object sender, EventArgs e) {
        try {
            if (!(TextBoxSnumSearch.Text.Trim() == "" && TextBoxPatientNameSearch.Text.Trim() == ""))
            {
                GridViewPatients.Visible = true;
                GridViewPatients.DataBind();
            } else {
                GridViewPatients.Visible = false;
            }

            PanelPatientExistsNotice.Visible = false;
        } catch (Exception _ex) {
            Logging.WriteLogToFile("PolyTraumaEntry ButtonSearchPatient_Click exception: " + _ex.ToString());
        }
    }

    protected void LinkButtonEditPatientInformation_Click(object sender, EventArgs e) {
        SetFormToEditPolyTraumaWithPatientDetails();
    }

    protected void GridViewPatients_SelectedIndexChanged(object sender, EventArgs e) {
        try {
            PATIENT patientEntry;
            PatientManager patientManager = new PatientManager();
            patientEntry = patientManager.SelectByID((int)GridViewPatients.SelectedDataKey.Value);

            //check if patient exists in polytrauma database by comparing SSN
            if (PolyTraumaManager.SSNExistsInPolyTrauma(patientEntry.Snum)) {
                //if the ssn exists in polytrauma alert user and ask if it is a new admission
                PanelPatientExistsNotice.Visible = true;

                HiddenFieldPatientExistsSelectedID.Value = patientEntry.PATIENT_ID.ToString();
            } else {
                PanelPatientExistsNotice.Visible = false;
                TransferPatientInformationToNewPolyTraumaEntry(patientEntry);
                SetFormToEditPolyTraumaWithPatientDetails();
            }

        } catch (Exception _ex) {
            Logging.WriteLogToFile("PolyTraumaEntry GridViewPatients_SelectedIndexChanged exception: " + _ex.ToString());
        }
    }

    /// <summary>
    /// PolyTrauma Entry Type selection change
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void rblPolytraumaEntryType_SelectedIndexChanged(object sender, EventArgs e) {
        SetEntryTypeForm();

        SetAdmissionOrFollowUpForm();
    }

    /// <summary>
    /// Fired when Admission or FollowUp is selected.
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void rblIsFollowUp_SelectedIndexChanged(object sender, EventArgs e) {
        // TODO: hide / show areas for admission or followup
        SetAdmissionOrFollowUpForm();
    }

    #endregion Protected Methods

    #region Private Methods

    void Page_PreRender(object sender, EventArgs e) {
        if (polyTraumEntry != null) {
            //This is the last event in the page life cycle where changes can be made to the page object
            //so enforce business rules on the object (which could possibly change the propertie of the object
            //then load the form controls from the object

            //Enforce business rules on the referral object
            //need to call EnforceBusinessRules method in the ReferralManager because some rules require a database call
            //pass in the local instance of referral to the method.  The method will return the object with modifications due to business rules.
            if (IsPostBack) {
                int ret;
                ret = PolyTraumaManager.EnforceBusinessRules(ref polyTraumEntry);
            }

            //Load Controls from the Object
            LoadControlsFromObject();
        }

        if (!this.ReadOnly) {
            const string scriptName = "__polyTraumaClientSideScript";
            if (!Page.ClientScript.IsClientScriptIncludeRegistered(scriptName)) {
                Page.ClientScript.RegisterClientScriptBlock(Page.GetType(), scriptName, GetPageJavaScript(), true);
            }
        }

        if (this.AllowUpdate) {
            ButtonSave.Visible = true;
        } else {
            ButtonSave.Visible = false;
        }

        if (polyTraumEntry != null)
        {
            if (CurrentUser.IsSuperUser && polyTraumEntry.TBI_POLYTRAUMA_ID > 0)
            {
                btnDelete.Visible = true;
                btnPTRPDelete.Visible = true;
            }
            else
            {
                btnDelete.Visible = false;
                btnPTRPDelete.Visible = false;
            }

            if ((polyTraumEntry.ENTRY_TYPE_ID == 1 && polyTraumEntry.REHAB_DISCHARGE_DATE == null && polyTraumEntry.IS_FOLLOW_UP != true) || 
                (polyTraumEntry.ENTRY_TYPE_ID == 2 && polyTraumEntry.PTRP_DISCHARGE_DATE == null && polyTraumEntry.IS_FOLLOW_UP != true))
            {
                rblIsFollowUp.Enabled = false;
                if (rblIsFollowUp.SelectedIndex == -1)
                {
                    rblIsFollowUp.SelectedIndex = 0;
                }
            }
            else
            {
                rblIsFollowUp.Enabled = true;
            }
            bool isFollowUp = false;
            if (polyTraumEntry.IS_FOLLOW_UP != null)
            {
                if (polyTraumEntry.IS_FOLLOW_UP == true)
                {
                    isFollowUp = true;
                }
            }

            RehabAdmitDate.ReadOnly = RehabAdmitDate.Date.Text.Trim().Length != 0 && isFollowUp;
            RehabDischargeDate.ReadOnly = RehabDischargeDate.Date.Text.Trim().Length != 0 && isFollowUp;
            trPRCFollowupDate.Visible = isFollowUp;

            PTRPAdmissionDate.ReadOnly = PTRPAdmissionDate.Date.Text.Trim().Length != 0 && isFollowUp;
            PTRPDischargeDate.ReadOnly = PTRPDischargeDate.Date.Text.Trim().Length != 0 && isFollowUp;
            trPTRPFollowupDate.Visible = isFollowUp;
        }
        else
        {
            btnDelete.Visible = false;
            btnPTRPDelete.Visible = false;
        }
    }

    /// <summary>
    /// Sets the BreadCrumb label on edit.
    /// </summary>
    /// <param name="entryId"></param>
    private void SetBreadCrumbLabelText(int? entryId) {
        SetFormToEditPolyTraumaHidePatientDetails(entryId.GetValueOrDefault());

        //Modify breadcrumb to display editing ID
        LabelBreadCrumb.Text = LabelBreadCrumb.Text + " > Edit Tracking Item ID : " + entryId;
    }

    private string GetPageJavaScript() {
        StringBuilder myStringBuilder = new StringBuilder();

        myStringBuilder.Append("function SetTextBoxOtherInjuryDescriptionEnabledStatus()");
        myStringBuilder.Append("{");
        myStringBuilder.Append("var TextBoxOtherInjuryDescription = document.getElementById('" + TextBoxOtherInjuryDescription.ClientID + "');");
        myStringBuilder.Append("if ($get('" + DropDownListOtherInjury.ClientID + "').value  != 'Y')");
        myStringBuilder.Append("{");
        myStringBuilder.Append("TextBoxOtherInjuryDescription.value = '';");
        myStringBuilder.Append("TextBoxOtherInjuryDescription.disabled = true;");
        myStringBuilder.Append("}");
        myStringBuilder.Append("else");
        myStringBuilder.Append("{");
        myStringBuilder.Append("TextBoxOtherInjuryDescription.disabled = false;");
        myStringBuilder.Append("}");
        myStringBuilder.Append("}");

        return myStringBuilder.ToString();
    }

    private void SetFormToNewPatientSearchMode() {
        PanelSelectPatient.Visible = true;
        PanelManualPatientEntry.Visible = true;
        LabelOrMessage.Visible = true;
        PanelPatient.Visible = false;
        PanelPatientReadOnly.Visible = false;
        PanelTracking.Visible = false;
        PanelPatientExistsNotice.Visible = false;
        PanelSSNExists.Visible = false;

        PanelEntryType.Visible = false;
        PanelPTRP.Visible = false;

        SetDOBDODCompareValidators();
    }

    private void SetFormToNoInsertAllowedMode() {
        PanelNoInsertAllowed.Visible = true;

        PanelSelectPatient.Visible = false;
        PanelManualPatientEntry.Visible = false;
        LabelOrMessage.Visible = false;
        PanelPatient.Visible = false;
        PanelPatientReadOnly.Visible = false;
        PanelTracking.Visible = false;
        PanelPatientExistsNotice.Visible = false;
        PanelSSNExists.Visible = false;
        PanelPTRP.Visible = false;
        PanelEntryType.Visible = false;

        SetDOBDODCompareValidators();
    }

    private void SetFormToEditPolyTraumaHidePatientDetails(int entryID) {
        PanelSelectPatient.Visible = false;
        PanelManualPatientEntry.Visible = false;
        LabelOrMessage.Visible = false;
        PanelPatient.Visible = false;
        PanelPatientReadOnly.Visible = true;
        PanelTracking.Visible = true;
        PanelPatientExistsNotice.Visible = false;
        PanelSSNExists.Visible = false;

        SetEntryTypeForm();

        SetDOBDODCompareValidators();
    }

    protected void ShowPRCPanelButtonClick(object sender, EventArgs e)
    {
        ToggleEntryTypePanels("prc", false);
    }

    protected void ShowPTRPPanelButtonClick(object sender, EventArgs e)
    {
        ToggleEntryTypePanels("ptrp", false);
    }

    private void ToggleEntryTypePanels(string entryType)
    {
        ToggleEntryTypePanels(entryType, true);
    }

    private bool toggleHandled = false;
    private void ToggleEntryTypePanels(string entryType, bool checkToggleButtonVisibility)
    {
        //only allow this method's body to run once per post-back
        if (toggleHandled)
            return;
        toggleHandled = true;
        bool isBoth = entryType == "both";
        bool ptrpWasVisible = PanelPTRP.Visible;

        ShowPRCPanelButton.Visible = isBoth || !checkToggleButtonVisibility;
        ShowPTRPPanelButton.Visible = isBoth || !checkToggleButtonVisibility;
        PanelPTRP.Visible = isBoth || !checkToggleButtonVisibility || entryType == "ptrp";
        PanelTracking.Visible = isBoth || !checkToggleButtonVisibility || entryType == "prc";
        if (isBoth)
        {
            //BOTH was just seleced or the page is loading for the first time with a value of BOTH
            PanelPTRP.Style["display"] = VisibleToDisplay(ptrpWasVisible);
            PanelTracking.Style["display"] = VisibleToDisplay(!ptrpWasVisible);
        }
        else if (!checkToggleButtonVisibility)
        {
            //BOTH is selected and the user is toggling the visible page
            bool isPTRP = entryType != "prc";
            PanelPTRP.Style["display"] = VisibleToDisplay(isPTRP);
            PanelTracking.Style["display"] = VisibleToDisplay(!isPTRP);
        }
        else
        {
            //Either PRC or PTRP is selected and the Visible property will exclude the appropriate content
            PanelPTRP.Style["display"] = VisibleToDisplay(true);
            PanelTracking.Style["display"] = VisibleToDisplay(true);
        }
    }

    private string VisibleToDisplay(bool visible)
    {
        return visible ? "normal" : "none";
    }

    private void SetEntryTypeForm()
    {
        if (rblPolytraumaEntryType.SelectedIndex == -1)
            return;
        ToggleEntryTypePanels(rblPolytraumaEntryType.SelectedItem.Text.ToLower());
    }

    private void SetAdmissionOrFollowUpForm()
    {
        if (rblIsFollowUp.SelectedIndex > -1 && rblIsFollowUp.SelectedItem.Text.ToLower() == "admission")
        {
            pnlMPAIFollowUpScoresArea.Visible = false;
            pnlMPAIScoresArea.Visible = true;
            pnlMPAIQ26_SWLSAdmissionArea.Visible = true;
            pnlMPAIQ26_SWLSFollowUpArea.Visible = false;
            pnlPrimaryEmploymentStatusDischargeArea.Visible = true;
            pnlPrimaryEmploymentStatusFollowUpArea.Visible = false;
            pnlPrimaryPersonLivingDischargeArea.Visible = true;
            pnlPrimaryPersonLivingFollowUpArea.Visible = false;
        }
        else
        {
            pnlMPAIFollowUpScoresArea.Visible = true;
            pnlMPAIScoresArea.Visible = false;
            pnlMPAIQ26_SWLSAdmissionArea.Visible = false;
            pnlMPAIQ26_SWLSFollowUpArea.Visible = true;
            pnlPrimaryEmploymentStatusDischargeArea.Visible = false;
            pnlPrimaryEmploymentStatusFollowUpArea.Visible = true;
            pnlPrimaryPersonLivingDischargeArea.Visible = false;
            pnlPrimaryPersonLivingFollowUpArea.Visible = true;
        }
    }

    private void SetFormToEditPolyTraumaWithPatientDetails() {
        this.PanelPatient.Visible = true;
        this.PanelPatientReadOnly.Visible = false;
        this.PanelSelectPatient.Visible = false;
        PanelManualPatientEntry.Visible = false;
        LabelOrMessage.Visible = false;

        PanelPatientExistsNotice.Visible = false;
        PanelSSNExists.Visible = false;

        PanelEntryType.Visible = true;
        PanelPTRP.Visible = false;
        PanelTracking.Visible = false;

        SetDOBDODCompareValidators();
    }

    private void SetDOBDODCompareValidators() {
        if (this.PanelPatient.Visible) {
            //to do
            CompareValidatorDateAlteredConsciousnessDOB.ControlToCompare = "TextBoxDateOfBirth";
            CompareValidatorDateAlteredConsciousnessDOD.ControlToCompare = "TextBoxDateOfDeath";

            CompareValidatorPatientEmergedDateDOB.ControlToCompare = "TextBoxDateOfBirth";
            CompareValidatorPatientEmergedDateDOD.ControlToCompare = "TextBoxDateOfDeath";

            CompareValidatorRehabAdmitDateDOB.ControlToCompare = "TextBoxDateOfBirth";
            CompareValidatorRehabAdmitDateDOD.ControlToCompare = "TextBoxDateOfDeath";

            CompareValidatorRehabDischargeDateDOB.ControlToCompare = "TextBoxDateOfBirth";
            CompareValidatorRehabDischargeDateDOD.ControlToCompare = "TextBoxDateOfDeath";

        } else {
            CompareValidatorDateAlteredConsciousnessDOB.ControlToCompare = "HiddenFieldDateOfBirth";
            CompareValidatorDateAlteredConsciousnessDOD.ControlToCompare = "HiddenFieldDateOfDeath";

            CompareValidatorPatientEmergedDateDOB.ControlToCompare = "HiddenFieldDateOfBirth";
            CompareValidatorPatientEmergedDateDOD.ControlToCompare = "HiddenFieldDateOfDeath";

            CompareValidatorRehabAdmitDateDOB.ControlToCompare = "HiddenFieldDateOfBirth";
            CompareValidatorRehabAdmitDateDOD.ControlToCompare = "HiddenFieldDateOfDeath";

            CompareValidatorRehabDischargeDateDOB.ControlToCompare = "HiddenFieldDateOfBirth";
            CompareValidatorRehabDischargeDateDOD.ControlToCompare = "HiddenFieldDateOfDeath";
        }
    }

    /// <summary>
    /// Displays Save Message
    /// </summary>
    /// <param name="returnSaveValue"></param>
    /// <param name="addNewTbiPolyTraumEntryId"></param>
    private void DisplaySaveMessage(int returnSaveValue, int addNewTbiPolyTraumEntryId) {
        //Fortify errors on this line (this.Master as RegistryMaster).SetDirtyFlag(false);
        ((RegistryMaster)Master).SetDirtyFlag(false);

        HiddenField hiddenFieldShowSaveMessage = ((HiddenField)this.Master.FindControl("HiddenFieldShowSaveMessage"));
        hiddenFieldShowSaveMessage.Value = "true";

        if (returnSaveValue > 0) {
            IsSaveSuccess = true;

            if (addNewTbiPolyTraumEntryId == 0) {
                //Response.Redirect(Request.Url.AbsolutePath + "?id=" + returnSaveValue);
                //int? entryID = Convert.ToInt32(Request.QueryString["id"]);
                //HiddenFieldEntryID.Value = entryID.GetValueOrDefault().ToString();
                //LabelBreadCrumb.Text = LabelBreadCrumb.Text + " > Edit Tracking Item ID : " + entryID;
                SetBreadCrumbLabelText(returnSaveValue);
            }
        } else {
            IsSaveSuccess = false;
        }
    }

    #endregion Private Methods

    #region Postback Events

    /// <summary>
    /// Main Save button - PRC
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void ButtonSave_Click(object sender, EventArgs e) {
        LoadObjectFromControls();

        int returnSaveValue = 0;

        Page.Validate();
        if (Page.IsValid) {
            if (polyTraumEntry.SnumChanged == true
                && HiddenFieldUserAcceptedSSN.Value != "true"
                && PolyTraumaManager.SSNExistsInPolyTrauma(polyTraumEntry.Snum)) {
                //if the ssn exists in polytrauma alert user and ask if it is a new admission
                PanelSSNExists.Visible = true;
                HiddenField focusField = (HiddenField)Master.FindControl("focusField");
                focusField.Value = ButtonContinueWithSSNChange.ClientID;

            } else {
                PanelSSNExists.Visible = false;

                if (!String.IsNullOrEmpty(HiddenFieldPatientID.Value)) {
                    PATIENT patientEntry;
                    PatientManager patientManager = new PatientManager();
                    patientEntry = patientManager.SelectByID(Convert.ToInt32(HiddenFieldPatientID.Value));

                    polyTraumEntry.PATIENT = patientEntry;
                    polyTraumEntry.PATIENT_ID = patientEntry.PATIENT_ID;
                }

                polyTraumEntry.INACTIVE_FLAG = false;
                polyTraumEntry.INACTIVE_DATE = null;

                int addNewTbiPolyTraumEntryId = polyTraumEntry.TBI_POLYTRAUMA_ID;
                this.SuppressSaveMessage = false;
                returnSaveValue = PolyTraumaManager.Update(polyTraumEntry);

                if (returnSaveValue > 0) {
                    HiddenFieldEntryID.Value = returnSaveValue.ToString();
                }

                //Set Broken Rule Error Display
                if (polyTraumEntry.BrokenRules.Count == 0) {
                    ErrorList1.Visible = false;
                } else {
                    ErrorList1.Visible = true;
                }

                ErrorList1.BrokenRules = polyTraumEntry.BrokenRules;
                DisplaySaveMessage(returnSaveValue, addNewTbiPolyTraumEntryId);
            }
        }
    }

    /// <summary>
    /// Event handler for btnPTRPSave control.  Will perform save for PTRP data.
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void btnPTRPSave_Click(object sender, EventArgs e) {
        int returnSaveValue = 0;
        Page.Validate();

        if (Page.IsValid) {
            if (polyTraumEntry.SnumChanged == true
                && HiddenFieldUserAcceptedSSN.Value != "true"
                && PolyTraumaManager.SSNExistsInPolyTrauma(polyTraumEntry.Snum)) {
                //if the ssn exists in polytrauma alert user and ask if it is a new admission
                PanelSSNExists.Visible = true;
                HiddenField focusField = (HiddenField)Master.FindControl("focusField");
                focusField.Value = ButtonContinueWithSSNChange.ClientID;

            } else {
                PanelSSNExists.Visible = false;

                polyTraumEntry.INACTIVE_FLAG = false;
                polyTraumEntry.INACTIVE_DATE = null;

                int addNewTbiPolyTraumEntryId = polyTraumEntry.TBI_POLYTRAUMA_ID;
                this.SuppressSaveMessage = false;
                returnSaveValue = PolyTraumaManager.Update(polyTraumEntry);

                if (returnSaveValue > 0) {
                    HiddenFieldEntryID.Value = returnSaveValue.ToString();
                }

                //Set Broken Rule Error Display
                if (polyTraumEntry.BrokenRules.Count == 0) {
                    ErrorList1.Visible = false;
                } else {
                    ErrorList1.Visible = true;
                }

                ErrorList1.BrokenRules = polyTraumEntry.BrokenRules;
                DisplaySaveMessage(returnSaveValue, addNewTbiPolyTraumEntryId);
            }
        }
    }

    protected void ButtonSkipPatient_Click(object sender, EventArgs e) {
        SetFormToEditPolyTraumaWithPatientDetails();
    }

    protected void ButtonPatientExistsContinue_Click(object sender, EventArgs e) {
        try {
            PATIENT patientEntry;
            PatientManager patientManager = new PatientManager();
            patientEntry = patientManager.SelectByID(Helpers.getIntFromString(HiddenFieldPatientExistsSelectedID.Value));

            PanelPatientExistsNotice.Visible = false;
            HiddenFieldPatientExistsSelectedID.Value = "";

            TransferPatientInformationToNewPolyTraumaEntry(patientEntry);

            SetFormToEditPolyTraumaWithPatientDetails();

            HiddenFieldUserAcceptedSSN.Value = "true";
        }
        catch (Exception _ex)
        {
            Logging.WriteLogToFile("PolyTraumaEntry ButtonPatientExistsContinue_Click exception: " + _ex.ToString());
            //_tbiexception.HandleTBIException(_ex, "PolyTraumaEntry", "1000033", "ButtonPatientExistsContinue_Click()");
        }
    }

    protected void ButtonContinueWithSSNChange_Click(object sender, EventArgs e) {
        HiddenFieldUserAcceptedSSN.Value = "true";
        ButtonSave_Click(sender, e);
    }

    protected void btnDelete_Click(object sender, EventArgs e)
    {
        //int polyTraumaId = polyTraumEntry.TBI_POLYTRAUMA_ID;
        //int deleteStatus = PolyTraumaManager.Delete(polyTraumaId);
        //Use soft delete

        RegistriesLinqDataContext rldc = new RegistriesLinqDataContext();

        polyTraumEntry.INACTIVE_FLAG = true;
        polyTraumEntry.INACTIVE_DATE = rldc.GetSystemDate();
        PolyTraumaManager.Update(polyTraumEntry);

        Response.Redirect("PolyTraumaEntries.aspx");
    }

    protected void lnkbtnChangeDischargeTo_Click(object sender, EventArgs e)
    {
        blnDischargeToEditMode = true;
    }

    protected void lnkbtnKeepInactiveDischargeToCode_Click(object sender, EventArgs e)
    {
        blnDischargeToEditMode = false;
        polyTraumEntry.STD_TBIDISCHARGETO_ID = _intOriginalTbiDischargetoCode;
        DropDownListRehabDischargedTo.SelectedIndex = 0;
    }

    #endregion Postback Events

    #region Object/Form Mapping

    /// <summary>
    /// Populate controls from Polytrauma object
    /// </summary>
    private void LoadControlsFromObject() {
        try {
            //populate dropdowns
            PopulateDropDowns();

            bool fullname = true;

            if (polyTraumEntry.ENTRY_TYPE_ID != null) {
                rblPolytraumaEntryType.SelectedValue = polyTraumEntry.ENTRY_TYPE_ID.ToString();
                SetEntryTypeForm();
            }

            if (polyTraumEntry.IS_FOLLOW_UP != null) {
                rblIsFollowUp.SelectedValue = (polyTraumEntry.IS_FOLLOW_UP == true) ? "1" : "0";
                SetAdmissionOrFollowUpForm();
            }

            if (polyTraumEntry.Snum != null) {
                //SSN
                TextBoxSnum.Text = polyTraumEntry.Snum;
                LabelSSNReadOnly.Text = AntiXssEnc.Encoder.HtmlEncode(polyTraumEntry.Snum);
            }

            if (polyTraumEntry.FIRST_NAME != null) {
                //First Name
                TextBoxFirstName.Text = polyTraumEntry.FIRST_NAME;
            } else {
                fullname = false;
            }

            if (polyTraumEntry.MIDDLE_NAME != null) {
                //Middle Name
                TextBoxMiddleName.Text = polyTraumEntry.MIDDLE_NAME;
            } else {
                fullname = false;
            }

            if (polyTraumEntry.LAST_NAME != null) {
                //Last Name
                TextBoxLastName.Text = polyTraumEntry.LAST_NAME;
            } else {
                fullname = false;
            }

            if (fullname == true) {
                //Label Full Name
                LabelFullName.Text = AntiXssEnc.Encoder.HtmlEncode(polyTraumEntry.LAST_NAME + ", " + polyTraumEntry.FIRST_NAME + (polyTraumEntry.MIDDLE_NAME == "" ? "" : " " + polyTraumEntry.MIDDLE_NAME));
            }

            if (polyTraumEntry.BIRTH_DATE != null) {
                //Date of Birth
                TextBoxDateOfBirth.Text = Helpers.getShortDateStringFromNullableDate(polyTraumEntry.BIRTH_DATE);
                HiddenFieldDateOfBirth.Text = TextBoxDateOfBirth.Text;
            }

            //DateOfBirth.DateValue = Helpers.getShortDateStringFromNullableDate(polyTraumEntry.BIRTH_DATE);
            if (polyTraumEntry.STD_GENDER_ID != null) {
                //Gender
                DropDownListGender.SelectedValue = polyTraumEntry.STD_GENDER_ID.ToString();
            }

            if (polyTraumEntry.STD_MARITALSTATUS_ID != null) {
                //Marital Status
                DropDownListMaritalStatus.SelectedValue = polyTraumEntry.STD_MARITALSTATUS_ID.ToString();
            }

            if (polyTraumEntry.STD_RACE_ID != null) {
                //Race
                DropDownListRace.SelectedValue = polyTraumEntry.STD_RACE_ID.ToString();
            }

            if (polyTraumEntry.STD_ETHNICITY_ID != null) {
                //Ethnicity
                DropDownListEthnicity.SelectedValue = polyTraumEntry.STD_ETHNICITY_ID.ToString();
            }

            if (polyTraumEntry.DEATH_DATE != null) {
                //Date of Death
                TextBoxDateOfDeath.Text = Helpers.getShortDateStringFromNullableDate(polyTraumEntry.DEATH_DATE);
                HiddenFieldDateOfDeath.Text = TextBoxDateOfDeath.Text;
            }

            //DateOfDeath.DateValue = Helpers.getShortDateStringFromNullableDate(polyTraumEntry.DEATH_DATE);
            if (polyTraumEntry.ADDRESS_LINE1 != null) {
                //Address
                TextBoxAddressLine1.Text = polyTraumEntry.ADDRESS_LINE1;
            }

            if (polyTraumEntry.ADDRESS_LINE2 != null) {
                //Address Line 2
                TextBoxAddressLine2.Text = polyTraumEntry.ADDRESS_LINE2;
            }

            if (polyTraumEntry.ADDRESS_LINE3 != null) {
                //Adrress Line3
                TextBoxAddressLine3.Text = polyTraumEntry.ADDRESS_LINE3;
            }

            if (polyTraumEntry.CITY != null) {
                //City
                TextBoxCity.Text = polyTraumEntry.CITY;
            }

            if (polyTraumEntry.STATE != null) {
                //State
                TextBoxState.Text = polyTraumEntry.STATE;
            }
            if (polyTraumEntry.COUNTY != null) {
                //County
                TextBoxCounty.Text = polyTraumEntry.COUNTY;
            }

            if (polyTraumEntry.COUNTRY != null) {
                //Country
                TextBoxCountry.Text = polyTraumEntry.COUNTRY;
            }

            if (polyTraumEntry.POSTAL_CODE != null) {
                //Postal Code
                TextBoxPostalCode.Text = polyTraumEntry.POSTAL_CODE;
            }
            if (polyTraumEntry.HOME_PHONE != null) {
                //Home Phone
                TextBoxHomePhone.Text = polyTraumEntry.HOME_PHONE;
            }

            if (polyTraumEntry.EMAIL_ADDRESS != null) {
                //Email Address
                TextBoxEmailAddress.Text = polyTraumEntry.EMAIL_ADDRESS;
            }

            if (polyTraumEntry.PATIENT_HOME_VAMC_ID != null) {
                //Home VAMC
                DropDownListHomeVAMC.SelectedValue = polyTraumEntry.PATIENT_HOME_VAMC_ID.ToString();
            }

            if (polyTraumEntry.TBI_POLYTRAUMA_ID != null) {
                if (polyTraumEntry.TBI_POLYTRAUMA_ID > 0) {
                    LabelHomeVAMCReadOnly.Text = PolyTraumaManager.getHomeVAMCName(polyTraumEntry.TBI_POLYTRAUMA_ID);
                }
            }

            if (polyTraumEntry.STD_SERVICEBRANCH_ID != null) {
                //Military Service Branch
                DropDownListMilitartServiceBranch.SelectedValue = polyTraumEntry.STD_SERVICEBRANCH_ID.ToString();
            }

            if (polyTraumEntry.STD_MILITARYDUTYSTS_ID != null) {
                //Military Duty Status
                DropDownListMilitaryServiceStatus.SelectedValue = polyTraumEntry.STD_MILITARYDUTYSTS_ID.ToString();
            }

            if (polyTraumEntry.STD_TBIDSCHRGSTS_ID != null) {
                //Discharge Status
                DropDownListDischargeStatus.SelectedValue = polyTraumEntry.STD_TBIDSCHRGSTS_ID.ToString();
            }

            if (polyTraumEntry.STD_TBIFACILITYSRC_ID != null) {
                //MTF / Referral Source
                DropDownListTBIFacilitySource.SelectedValue = polyTraumEntry.STD_TBIFACILITYSRC_ID.ToString();
            }

            if (polyTraumEntry.TBI_INJURY_DATE != null) {
                if (polyTraumEntry.TBI_INJURY_DATE.HasValue) {
                    //Injury Date
                    TextBoxInjuryDate.Text = Helpers.getShortDateStringFromNullableDate(polyTraumEntry.TBI_INJURY_DATE);
                }
            }
            //InjuryDate.DateValue = Helpers.getShortDateStringFromNullableDate(polyTraumEntry.TBI_INJURY_DATE);
            RangeValidatorTextBoxInjuryDate.MinimumValue = DateTime.MinValue.ToShortDateString();
            RangeValidatorTextBoxInjuryDate.MaximumValue = DateTime.Now.ToShortDateString();

            if (polyTraumEntry.STD_COMBATLOCATION_ID != null) {
                //Combat Location
                DropDownListCombatLocation.SelectedValue = polyTraumEntry.STD_COMBATLOCATION_ID.ToString();
            }

            if (polyTraumEntry.BLAST_EXPLOSION_INJRY_IND != null) {
                DropDownListBlastExplosion.SelectedValue = polyTraumEntry.BLAST_EXPLOSION_INJRY_IND.Value.ToString();
            }

            if (polyTraumEntry.VEHICLE_INJRY_IND != null) {
                DropDownListVechicleInjury.SelectedValue = polyTraumEntry.VEHICLE_INJRY_IND.Value.ToString();
            }

            if (polyTraumEntry.BULLET_INJRY_IND != null) {
                DropDownListBulletInjury.SelectedValue = polyTraumEntry.BULLET_INJRY_IND.Value.ToString();
            }

            if (polyTraumEntry.PHYS_ASSAULT_INJRY_IND != null) {
                DropDownListPhysicalAssault.SelectedValue = polyTraumEntry.PHYS_ASSAULT_INJRY_IND.Value.ToString();
            }

            if (polyTraumEntry.OTHER_INJRY_IND != null) {
                DropDownListOtherInjury.SelectedValue = polyTraumEntry.OTHER_INJRY_IND.Value.ToString();
            }

            //Other Injury Description
            if (DropDownListOtherInjury.SelectedValue != null) {
                if (DropDownListOtherInjury.SelectedValue == "Y") {
                    if (polyTraumEntry.OTHER_INJRY_DSCR != null) {
                        if (polyTraumEntry.OTHER_INJRY_DSCR.Length > 0) {
                            TextBoxOtherInjuryDescription.Text = polyTraumEntry.OTHER_INJRY_DSCR;
                        }
                    }

                    if (!this.ReadOnly) {
                        TextBoxOtherInjuryDescription.Enabled = true;
                    }
                } else {
                    //set other description to non editable
                    TextBoxOtherInjuryDescription.Text = "";
                    TextBoxOtherInjuryDescription.Enabled = false;
                }
            }

            if (polyTraumEntry.TBI_INJURY_DETAILs != null) {
                //Injury Details
                foreach (TBI_INJURY_DETAIL injury in polyTraumEntry.TBI_INJURY_DETAILs) {
                    ListItem foundListItem = CheckBoxListInjuryDetails.Items.FindByValue(injury.STD_TBIINJURYLIST_ID.ToString());

                    if (foundListItem != null) {
                        foundListItem.Selected = true;
                    }
                }
            }

            // severity index of TBI
            if (polyTraumEntry.SEVERITY_LEVEL_INDEX_ID != null) {
                rblSeverityLevelIndexTBI.SelectedValue = polyTraumEntry.SEVERITY_LEVEL_INDEX_ID.ToString();
            }

            if (polyTraumEntry.PROVIDER_LOCATION != null) {
                //Provider Location
                //DropDownListProviderLocation.SelectedValue = polyTraumEntry.STD_TBIPROVIDERLOC_ID.ToString();
                TextBoxFollowupProviderLocation.Text = polyTraumEntry.PROVIDER_LOCATION;
            }

            //Provider ID Number
            //TextBoxProviderIDNumber.Text = polyTraumEntry.PROVIDER_ID_NUMBER;
            if (polyTraumEntry.PROVIDER_NAME != null) {
                //Follow Up Polytrauma Case Manager
                TextBoxProviderName.Text = polyTraumEntry.PROVIDER_NAME;
            }

            if (polyTraumEntry.PROVIDER_EMAIL != null) {
                //Provider Email
                TextBoxProviderEmail.Text = polyTraumEntry.PROVIDER_EMAIL;
            }

            if (polyTraumEntry.PROVIDER_PHONE != null) {
                //Provider Phone
                TextBoxProviderPhone.Text = polyTraumEntry.PROVIDER_PHONE;
            }

            if (polyTraumEntry.POLYTRAUMA_CENTER_ID != null) {
                //PolyTrauma VAMC
                if (polyTraumEntry.POLYTRAUMA_CENTER_ID.ToString().Length > 0) {
                    DropDownListPolyTraumaVAMC.SelectedValue = polyTraumEntry.POLYTRAUMA_CENTER_ID.ToString();
                }
            }

            if (polyTraumEntry.EMERGE_CONSCIOUSNESS_FLAG != null) {
                //Is Patient Emerging Consciousness
                CheckBoxEmergingConsciousness.Checked = (polyTraumEntry.EMERGE_CONSCIOUSNESS_FLAG == 1 ? true : false);
            }

            if (polyTraumEntry.STD_TBIEMERGINGETIOLOGY_ID != null) {
                //Emerging Etiology
                if (polyTraumEntry.STD_TBIEMERGINGETIOLOGY_ID.HasValue == true) {
                    DropDownListEmergingEtiology.SelectedValue = polyTraumEntry.STD_TBIEMERGINGETIOLOGY_ID.ToString();
                }
            }

            if (polyTraumEntry.ALTERED_CONSCIOUSNESS_DATE != null) {
                //Date Altered Consciousness
                if (polyTraumEntry.ALTERED_CONSCIOUSNESS_DATE.HasValue) {
                    TextBoxDateAlteredConsciousness.Text = Helpers.getShortDateStringFromNullableDate(polyTraumEntry.ALTERED_CONSCIOUSNESS_DATE);
                }
            }
            //DateAlteredConsciousness.DateValue = Helpers.getShortDateStringFromNullableDate(polyTraumEntry.ALTERED_CONSCIOUSNESS_DATE);
            RangeValidatorDateAlteredConsciousness.MinimumValue = DateTime.MinValue.ToShortDateString();
            RangeValidatorDateAlteredConsciousness.MaximumValue = DateTime.Now.ToShortDateString();

            if (polyTraumEntry.EMERGE_CONSCIOUSNESS_DATE != null) {
                if (polyTraumEntry.EMERGE_CONSCIOUSNESS_DATE.HasValue) {
                    //Date Patient Emerged
                    //TextBoxPatientEmergedDate.Text = Helpers.getShortDateStringFromNullableDate(polyTraumEntry.EMERGE_CONSCIOUSNESS_DATE);
                    PatientEmergedDate.DateValue = Helpers.getShortDateStringFromNullableDate(polyTraumEntry.EMERGE_CONSCIOUSNESS_DATE);
                }
            }

            // JFK Coma Recovery Scale
            if (polyTraumEntry.JFK_COMA_RECOVERY != null) {
                ddlJFKComaRecoveryScale.SelectedValue = polyTraumEntry.JFK_COMA_RECOVERY.ToString();
            }

            // Genito-Urinary Injuries
            if (polyTraumEntry.GENITO_URINARY_INJURIES != null) {
                if (polyTraumEntry.GENITO_URINARY_INJURIES == true) {
                    rblGenitoUrinaryInjuries.SelectedValue = "1";
                } else {
                    rblGenitoUrinaryInjuries.SelectedValue = "0";
                }
            }

            if (polyTraumEntry.REHAB_ADMIT_DATE != null) {
                if (polyTraumEntry.REHAB_ADMIT_DATE.HasValue) {
                    //Admission Date
                    RehabAdmitDate.DateValue = Helpers.getShortDateStringFromNullableDate(polyTraumEntry.REHAB_ADMIT_DATE);
                }
            }

            // Days from Onset to Admission
            if (polyTraumEntry.DAYS_FROM_ONSET != null) {
                LabelDaysFromOnsetValue.Text = polyTraumEntry.DAYS_FROM_ONSET.ToString();
            }

            if (polyTraumEntry.DAYS_OFF_UNIT_TOTAL != null) {
                //TextBoxDaysOffUnit
                if (polyTraumEntry.DAYS_OFF_UNIT_TOTAL.HasValue) {
                    TextBoxDaysOffUnit.Text = polyTraumEntry.DAYS_OFF_UNIT_TOTAL.ToString();
                }
            }

            if (polyTraumEntry.ADMISSION_FIM_CODE != null) {
                //Admission FIM Code
                if (polyTraumEntry.ADMISSION_FIM_CODE.Length > 0) {
                    TextBoxAdmissionFIMScore.Text = polyTraumEntry.ADMISSION_FIM_CODE;
                }
            }

            if (polyTraumEntry.STD_TBI_FRG_ID != null) {
                //FRG Code
                if (polyTraumEntry.STD_TBI_FRG_ID.HasValue) {
                    DropDownListFRGCode.SelectedValue = polyTraumEntry.STD_TBI_FRG_ID.ToString();
                }
            }

            if (polyTraumEntry.REHAB_DISCHARGE_DATE != null) {
                //Rehab Discharge Date
                //TextBoxRehabDischargeDate.Text = Helpers.getShortDateStringFromNullableDate(polyTraumEntry.REHAB_DISCHARGE_DATE);
                if (polyTraumEntry.REHAB_DISCHARGE_DATE.HasValue) {
                    RehabDischargeDate.DateValue = Helpers.getShortDateStringFromNullableDate(polyTraumEntry.REHAB_DISCHARGE_DATE);
                }
            }

            if (polyTraumEntry.DISCHARGE_FIM_CODE != null) {
                //Discharge FIM Code
                if (polyTraumEntry.DISCHARGE_FIM_CODE.Length > 0) {
                    TextBoxDischargeFIMScore.Text = polyTraumEntry.DISCHARGE_FIM_CODE;
                }
            }

            if (polyTraumEntry.STD_TBIDISCHARGETO_ID != null) {
                //Discharged To
                if (polyTraumEntry.STD_TBIDISCHARGETO_ID.HasValue)
                {
                    bool isDischargeToActive = PolyTraumaManager.IsDischargeToActive(polyTraumEntry.STD_TBIDISCHARGETO_ID);
                    if (!isDischargeToActive)
                    {
                        if (blnDischargeToEditMode)
                        {
                            //DropDownListRehabDischargedTo.SelectedIndex = 0;
                            DropDownListRehabDischargedTo.Visible = true;
                            lblDischargeTo.Text = "";
                            lblDischargeTo.Visible = false;
                            lblInactiveValue.Visible = false;
                            lnkbtnChangeDischargeTo.Visible = false;
                            lnkbtnKeepInactiveDischargeToCode.Visible = true;
                        }
                        else
                        {
                            DropDownListRehabDischargedTo.Visible = false;
                            lblDischargeTo.Text = PolyTraumaManager.GetDischargeToName(polyTraumEntry.STD_TBIDISCHARGETO_ID);
                            lblDischargeTo.Visible = true;
                            lblInactiveValue.Visible = true;
                            lnkbtnChangeDischargeTo.Visible = true;
                            lnkbtnKeepInactiveDischargeToCode.Visible = false;
                        }
                    }
                    else
                    {
                        DropDownListRehabDischargedTo.SelectedValue = polyTraumEntry.STD_TBIDISCHARGETO_ID.ToString();
                        DropDownListRehabDischargedTo.Visible = true;
                        lblDischargeTo.Text = "";
                        lblDischargeTo.Visible = false;
                        lblInactiveValue.Visible = false;
                        lnkbtnChangeDischargeTo.Visible = false;
                        lnkbtnKeepInactiveDischargeToCode.Visible = false;
                    }
                }
            }

            if (polyTraumEntry.TBI_FOLLOWUPs != null) {
                //Followup
                foreach (TBI_FOLLOWUP followup in polyTraumEntry.TBI_FOLLOWUPs) {
                    if (followup.STD_TBIIFOLLOWUPLIST_ID.ToString().Length > 0) {
                        ListItem foundListItem = CheckBoxListFollowUps.Items.FindByValue(followup.STD_TBIIFOLLOWUPLIST_ID.ToString());
                        foundListItem.Selected = true;
                    }
                }
            }
            if (polyTraumEntry.FOLLOWUP_SITE_DSCR != null) {
                if (polyTraumEntry.FOLLOWUP_SITE_DSCR.Length > 0) {
                    //Followup Site Description
                    TextBoxFollowupSiteDescription.Text = polyTraumEntry.FOLLOWUP_SITE_DSCR;
                }

            }

            if (polyTraumEntry.TotalLengthOfStay != null) {
                //LOS
                if (polyTraumEntry.TotalLengthOfStay.ToString().Length > 0) {
                    LabelLOSValue.Text = polyTraumEntry.TotalLengthOfStay.ToString();
                }
            }

            if (polyTraumEntry.AgeAtAdmission != null) {
                if (polyTraumEntry.AgeAtAdmission.ToString().Length > 0) {
                    //Age at Admission
                    if (polyTraumEntry.AgeAtAdmission > 0) {
                        LabelAgeAtAdmission.Text = polyTraumEntry.AgeAtAdmission.ToString();
                    } else {
                        LabelAgeAtAdmission.Text = "";
                    }
                }
            }

            if (polyTraumEntry.PRC_FOLLOWUP_DATE != null)
            {
                //PRC FOLLOW UP Date
                //TextBoxRehabDischargeDate.Text = Helpers.getShortDateStringFromNullableDate(polyTraumEntry.XXXXXXXXXXXXXXX);
                if (polyTraumEntry.PRC_FOLLOWUP_DATE.HasValue)
                {
                    PRCFollowupDate.DateValue = Helpers.getShortDateStringFromNullableDate(polyTraumEntry.PRC_FOLLOWUP_DATE);
                }
            }

            // PTRP areas

            // PTRP: Program
            if (!String.IsNullOrEmpty(polyTraumEntry.PTRP_PROGRAM)) {
                rblPTRPProgram.SelectedValue = polyTraumEntry.PTRP_PROGRAM;
            }

            // PTRP: Preinjury Primary Person Living With
            if (polyTraumEntry.PREINJURY_PRIM_PERSON_LIVING_WITH_ID != null) {
                ddlPTRPPreinjuryPrimaryPersonLivingWith.SelectedValue = polyTraumEntry.PREINJURY_PRIM_PERSON_LIVING_WITH_ID.ToString();
            }

            // PTRP: Preinjury Residence
            if (polyTraumEntry.PREINJURY_RESIDENCE_ID != null) {
                ddlPTRPPreinjuryResidence.SelectedValue = polyTraumEntry.PREINJURY_RESIDENCE_ID.ToString();
            }

            // PTRP: Preinjury Primary Employment Status
            if (polyTraumEntry.PRI_PREINJURY_EMPLOY_STATUS_ID != null) {
                ddlPTRPPreinjuryPriEmployStatus.SelectedValue = polyTraumEntry.PRI_PREINJURY_EMPLOY_STATUS_ID.ToString();
            }

            // PTRP: Preinjury Secondary Employment Status
            if (polyTraumEntry.SEC_PREINJURY_EMPLOY_STATUS_ID != null) {
                ddlPTRPPreinjurySecEmployStatus.SelectedValue = polyTraumEntry.SEC_PREINJURY_EMPLOY_STATUS_ID.ToString();
            }

            // PTRP: MPAI Abilities Initial
            if (polyTraumEntry.MPAI_ABILITIES_INITIAL != null) {
                txtMPAIAbilitiesInitial.Text = polyTraumEntry.MPAI_ABILITIES_INITIAL.ToString();
            }

            // PTRP: MPAI Abilities Discharge
            if (polyTraumEntry.MPAI_ABILITIES_DC != null) {
                txtMPAIAbilitiesDischarge.Text = polyTraumEntry.MPAI_ABILITIES_DC.ToString();
            }

            // PTRP: MPAI Abilities Followup
            if (polyTraumEntry.MPAI_ABILITIES_FOLLOWUP != null) {
                txtMPAIAbilitiesFollowup.Text = polyTraumEntry.MPAI_ABILITIES_FOLLOWUP.ToString();
            }

            // PTRP: MPAI Adjustment Initial
            if (polyTraumEntry.MPAI_ADJUSTMENT_INITIAL != null) {
                txtMPAIAdjustmentInitial.Text = polyTraumEntry.MPAI_ADJUSTMENT_INITIAL.ToString();
            }

            // PTRP: MPAI Adjustment Discharge
            if (polyTraumEntry.MPAI_ADJUSTMENT_DC != null) {
                txtMPAIAdjustmentDischarge.Text = polyTraumEntry.MPAI_ADJUSTMENT_DC.ToString();
            }

            // PTRP: MPAI Adjustment FollowUp
            if (polyTraumEntry.MPAI_ADJUSTMENT_FOLLOWUP != null) {
                txtMPAIAdjustmentFollowUp.Text = polyTraumEntry.MPAI_ADJUSTMENT_FOLLOWUP.ToString();
            }

            // PTRP: MPAI Participation Initial
            if (polyTraumEntry.MPAI_PARTICIPATION_INITIAL != null) {
                txtMPAIParticipationInitial.Text = polyTraumEntry.MPAI_PARTICIPATION_INITIAL.ToString();
            }

            // PTRP: MPAI Participation Discharge
            if (polyTraumEntry.MPAI_PARTICIPATION_DC != null) {
                txtMPAIParticipationDischarge.Text = polyTraumEntry.MPAI_PARTICIPATION_DC.ToString();
            }

            // PTRP: MPAI Participation FollowUp
            if (polyTraumEntry.MPAI_PARTICIPATION_FOLLOWUP != null) {
                txtMPAIParticipationFollowUp.Text = polyTraumEntry.MPAI_PARTICIPATION_FOLLOWUP.ToString();
            }

            // PTRP: MPAI Total Initial
            if (polyTraumEntry.MPAI_TOTAL_INITIAL != null) {
                txtMPAITotalInitial.Text = polyTraumEntry.MPAI_TOTAL_INITIAL.ToString();
            }

            // PTRP: MPAI Total Discharge
            if (polyTraumEntry.MPAI_TOTAL_DC != null) {
                txtMPAITotalDischarge.Text = polyTraumEntry.MPAI_TOTAL_DC.ToString();
            }

            // PTRP: MPAI Total FollowUp
            if (polyTraumEntry.MPAI_TOTAL_FOLLOWUP != null) {
                txtMPAITotalFollowUp.Text = polyTraumEntry.MPAI_TOTAL_FOLLOWUP.ToString();
            }

            // PTRP: MPAI Question 26 Residence Admission
            if (polyTraumEntry.MPAI_Q26_ADMISSION != null) {
                rblMPAIQuestion26ResidenceAdmission.SelectedValue = polyTraumEntry.MPAI_Q26_ADMISSION.ToString();
            }

            // PTRP: MPAI Question 26 Residence Discharge
            if (polyTraumEntry.MPAI_Q26_DC != null) {
                rblMPAIQuestion26ResidenceDischarge.SelectedValue = polyTraumEntry.MPAI_Q26_DC.ToString();
            }

            // PTRP: MPAI Question 26 Residence FollowUp
            if (polyTraumEntry.MPAI_Q26_FOLLOWUP != null) {
                rblMPAIQuestion26ResidenceFollowUp.SelectedValue = polyTraumEntry.MPAI_Q26_FOLLOWUP.ToString();
            }

            // PTRP: Satisfaction With Life Initial
            if (polyTraumEntry.SATIS_W_LIFE_ADMISSION != null) {
                txtSatisfactionWithLifeInitial.Text = polyTraumEntry.SATIS_W_LIFE_ADMISSION.ToString();
            }

            // PTRP: Satisfaction With Life Discharge
            if (polyTraumEntry.SATIS_W_LIFE_DC != null) {
                txtSatisfactionWithLifeDischarge.Text = polyTraumEntry.SATIS_W_LIFE_DC.ToString();
            }

            // PTRP: Satisfaction With Life FollowUp
            if (polyTraumEntry.SATIS_W_LIFE_FOLLOWUP != null) {
                txtSatisfactionWithLifeFollowUp.Text = polyTraumEntry.SATIS_W_LIFE_FOLLOWUP.ToString();
            }

            // PTRP: PART FollowUp
            if (polyTraumEntry.PART_FOLLOWUP != null) {
                txtPARTFollowUp.Text = polyTraumEntry.PART_FOLLOWUP.ToString();
            }

            // PTRP: Military Duty Status At Discharge -- Removed by Stakeholder (2/26/14)
            //if (polyTraumEntry.DC_MILITARY_DUTY_STATUS_ID != null) {
            //    ddlMilitaryDutyStatusAtDischarge.SelectedValue = polyTraumEntry.DC_MILITARY_DUTY_STATUS_ID.ToString();
            //}

            // PTRP: Discharge Primary Person Living With
            if (polyTraumEntry.PRI_PERSON_LIVING_DC_ID != null) {
                ddlPTRPDCPrimaryPersonLivingWith.SelectedValue = polyTraumEntry.PRI_PERSON_LIVING_DC_ID.ToString();
            }

            // PTRP: Follow Up Primary Person Living With
            if (polyTraumEntry.PRI_PERSON_LIVING_FOLLOWUP_ID != null) {
                ddlPTRPFollowUpPrimaryPersonLivingWith.SelectedValue = polyTraumEntry.PRI_PERSON_LIVING_FOLLOWUP_ID.ToString();
            }

            // PTRP: FollowUp Residence
            if (polyTraumEntry.FOLLOWUP_RESIDENCE_ID != null) {
                ddlPTRPFollowUpResidence.SelectedValue = polyTraumEntry.FOLLOWUP_RESIDENCE_ID.ToString();
            }

            // PTRP: Discharge Residence
            if (polyTraumEntry.DC_RESIDENCE_ID != null) {
                ddlPTRPDCResidence.SelectedValue = polyTraumEntry.DC_RESIDENCE_ID.ToString();
            }

            // PTRP: Discharge Primary Employment Status
            if (polyTraumEntry.PRI_DC_EMPLOY_STATUS_ID != null) {
                ddlPTRPDCPriEmployStatus.SelectedValue = polyTraumEntry.PRI_DC_EMPLOY_STATUS_ID.ToString();
            }

            // PTRP: Discharge Secondary Employment Status
            if (polyTraumEntry.SEC_DC_EMPLOY_STATUS_ID != null) {
                ddlPTRPDCSecEmployStatus.SelectedValue = polyTraumEntry.SEC_DC_EMPLOY_STATUS_ID.ToString();
            }

            // PTRP: FollowUp Primary Employment Status
            if (polyTraumEntry.PRI_FOLLOWUP_EMPLOY_STATUS_ID != null) {
                ddlPTRPFollowUpPriEmployStatus.SelectedValue = polyTraumEntry.PRI_FOLLOWUP_EMPLOY_STATUS_ID.ToString();
            }

            // PTRP: FollowUp Secondary Employment Status
            if (polyTraumEntry.SEC_FOLLOWUP_EMPLOY_STATUS_ID != null) {
                ddlPTRPFollowUpSecEmployStatus.SelectedValue = polyTraumEntry.SEC_FOLLOWUP_EMPLOY_STATUS_ID.ToString();
            }
            
            if (polyTraumEntry.PTRP_FOLLOWUP_DATE != null)
            {
                //PTRP FOLLOW UP Date
                if (polyTraumEntry.PRC_FOLLOWUP_DATE.HasValue)
                {
                    PTRPFollowupDate.DateValue = Helpers.getShortDateStringFromNullableDate(polyTraumEntry.PTRP_FOLLOWUP_DATE);
                }
            }

            if (polyTraumEntry.PTRP_ADMIT_DATE != null)
            {
                //PTRP Admission Date
                if (polyTraumEntry.PTRP_ADMIT_DATE.HasValue)
                {
                    PTRPAdmissionDate.DateValue = Helpers.getShortDateStringFromNullableDate(polyTraumEntry.PTRP_ADMIT_DATE);
                }
            }

            if (polyTraumEntry.PTRP_DISCHARGE_DATE != null)
            {
                //PTRP Discharge Date
                if (polyTraumEntry.PTRP_DISCHARGE_DATE.HasValue)
                {
                    PTRPDischargeDate.DateValue = Helpers.getShortDateStringFromNullableDate(polyTraumEntry.PTRP_DISCHARGE_DATE);
                }
            }

            //Set Range Validators for Date Of Birth and Date Of Death
            SetDatesRangeValidators(true);
        } 
        catch (Exception _ex)
        {
            Logging.WriteLogToFile("PolyTraumaEntry LoadControlsFromObject exception: " + _ex.ToString());
            //_tbiexception.HandleTBIException(_ex, "PolyTraumaEntry", "1000033", "ButtonPatientExistsContinue_Click()");
        }
    }


    /// <summary>
    /// Populate Polytrauma object from controls
    /// </summary>
    private void LoadObjectFromControls() {
        try {
            //SSN
            polyTraumEntry.Snum = TextBoxSnum.Text;

            //First Name
            polyTraumEntry.FIRST_NAME = TextBoxFirstName.Text;

            //Middle Name
            polyTraumEntry.MIDDLE_NAME = TextBoxMiddleName.Text;

            //Last Name
            polyTraumEntry.LAST_NAME = TextBoxLastName.Text;

            //Gender
            if (DropDownListGender.SelectedValue != null)
            {
                if (DropDownListGender.SelectedValue.Length > 0)
                {
                    polyTraumEntry.STD_GENDER_ID = Helpers.getIntFromString(DropDownListGender.SelectedValue);
                }
                else
                {
                    polyTraumEntry.STD_GENDER_ID = null;
                }
            }
            //polyTraumEntry.STD_GENDER_ID = Helpers.getNullableIntFromString(DropDownListGender.SelectedValue);

            //Date of Birth
            polyTraumEntry.BIRTH_DATE = Helpers.getNullableDateFromString(TextBoxDateOfBirth.Text);

            //Marital Status
            if (DropDownListMaritalStatus.SelectedValue != null)
            {
                if (DropDownListMaritalStatus.SelectedValue.Length > 0)
                {
                    polyTraumEntry.STD_MARITALSTATUS_ID = Helpers.getIntFromString(DropDownListMaritalStatus.SelectedValue);
                }
                else
                {
                    polyTraumEntry.STD_MARITALSTATUS_ID = null;
                }
            }
            //polyTraumEntry.STD_MARITALSTATUS_ID = Helpers.getNullableIntFromString(DropDownListMaritalStatus.SelectedValue);

            //Date of Death
            polyTraumEntry.DEATH_DATE = Helpers.getNullableDateFromString(TextBoxDateOfDeath.Text);

            //Race
            if (DropDownListRace.SelectedValue != null)
            {
                if (DropDownListRace.SelectedValue.Length > 0)
                {
                    polyTraumEntry.STD_RACE_ID = Helpers.getIntFromString(DropDownListRace.SelectedValue);
                }
                else
                {
                    polyTraumEntry.STD_ETHNICITY_ID = null;
                }
            }
            //polyTraumEntry.STD_RACE_ID = Helpers.getNullableIntFromString(DropDownListRace.SelectedValue);

            //Ethnicity
            if (DropDownListEthnicity.SelectedValue != null)
            {
                if (DropDownListEthnicity.SelectedValue.Length > 0)
                {
                    polyTraumEntry.STD_ETHNICITY_ID = Helpers.getIntFromString(DropDownListEthnicity.SelectedValue);
                }
                else
                {
                    polyTraumEntry.STD_ETHNICITY_ID = null;
                }
            }
            //polyTraumEntry.STD_ETHNICITY_ID = Helpers.getNullableIntFromString(DropDownListEthnicity.SelectedValue);

            //Address
            polyTraumEntry.ADDRESS_LINE1 = TextBoxAddressLine1.Text;

            //Address Line 2
            polyTraumEntry.ADDRESS_LINE2 = TextBoxAddressLine2.Text;

            //Adrress Line3
            polyTraumEntry.ADDRESS_LINE3 = TextBoxAddressLine3.Text;

            //City
            polyTraumEntry.CITY = TextBoxCity.Text;

            //State
            polyTraumEntry.STATE = TextBoxState.Text;

            //County
            polyTraumEntry.COUNTY = TextBoxCounty.Text;

            //Country
            polyTraumEntry.COUNTRY = TextBoxCountry.Text;

            //Postal Code
            polyTraumEntry.POSTAL_CODE = TextBoxPostalCode.Text;

            //Home Phone
            polyTraumEntry.HOME_PHONE = TextBoxHomePhone.Text;

            //Email Address
            polyTraumEntry.EMAIL_ADDRESS = TextBoxEmailAddress.Text;

            //Home VAMC
            if (DropDownListHomeVAMC.SelectedValue != null)
            {
                if (DropDownListHomeVAMC.SelectedValue.Length > 0)
                {
                    polyTraumEntry.PATIENT_HOME_VAMC_ID = Helpers.getIntFromString(DropDownListHomeVAMC.SelectedValue);
                }
                else
                {
                    polyTraumEntry.PATIENT_HOME_VAMC_ID = null;
                }
            }

            //Military Service Branch
            if (DropDownListMilitartServiceBranch.SelectedValue != null)
            {
                if (DropDownListMilitartServiceBranch.SelectedValue.Length > 0)
                {
                    polyTraumEntry.STD_SERVICEBRANCH_ID = Helpers.getNullableIntFromString(DropDownListMilitartServiceBranch.SelectedValue);
                }
                else
                {
                    polyTraumEntry.STD_SERVICEBRANCH_ID = null;
                }
            }

            //Military Duty Status
            if (DropDownListMilitaryServiceStatus.SelectedValue != null)
            {
                if (DropDownListMilitaryServiceStatus.SelectedValue.Length > 0)
                {
                    polyTraumEntry.STD_MILITARYDUTYSTS_ID = Helpers.getNullableIntFromString(DropDownListMilitaryServiceStatus.SelectedValue);
                }
                else
                {
                    polyTraumEntry.STD_MILITARYDUTYSTS_ID = null;
                }
            }

            //Discharge Status
            if (DropDownListDischargeStatus.SelectedValue != null)
            {
                if (DropDownListDischargeStatus.SelectedValue.Length > 0)
                {
                    polyTraumEntry.STD_TBIDSCHRGSTS_ID = Helpers.getNullableIntFromString(DropDownListDischargeStatus.SelectedValue);
                }
                else
                {
                    polyTraumEntry.STD_TBIDSCHRGSTS_ID = null;
                }
            }

            //MTF / Referral Source
            if (DropDownListTBIFacilitySource.SelectedValue != null)
            {
                if (DropDownListTBIFacilitySource.SelectedValue.Length > 0)
                {
                    polyTraumEntry.STD_TBIFACILITYSRC_ID = Helpers.getNullableIntFromString(DropDownListTBIFacilitySource.SelectedValue);
                }
                else
                {
                    polyTraumEntry.STD_TBIFACILITYSRC_ID = null;
                }
            }

            // TYPE
            if (!String.IsNullOrEmpty(rblPolytraumaEntryType.SelectedValue)) {
                polyTraumEntry.ENTRY_TYPE_ID = Convert.ToInt32(rblPolytraumaEntryType.SelectedValue);
            } else {
                polyTraumEntry.ENTRY_TYPE_ID = null;
            }

            // IS_FOLLOWUP
            if (!String.IsNullOrEmpty(rblIsFollowUp.SelectedValue)) {
                polyTraumEntry.IS_FOLLOW_UP = (rblIsFollowUp.SelectedValue == "1") ? true : false;
            } else {
                // if not set ... save as admission
                polyTraumEntry.IS_FOLLOW_UP = false;
            }

            // Trauma Info Area

            //Injury Date
            if (TextBoxInjuryDate.Text != null) {
                if (TextBoxInjuryDate.Text.Length > 0)
                {
                    polyTraumEntry.TBI_INJURY_DATE = Helpers.getNullableDateFromString(TextBoxInjuryDate.Text);
                }
                else
                {
                    polyTraumEntry.TBI_INJURY_DATE = null;
                }
            }

            //Combat Location
            if (DropDownListCombatLocation.SelectedValue != null)
            {
                if (DropDownListCombatLocation.SelectedValue.Length > 0)
                {
                    polyTraumEntry.STD_COMBATLOCATION_ID = Helpers.getNullableIntFromString(DropDownListCombatLocation.SelectedValue);
                }
                else
                {
                    polyTraumEntry.STD_COMBATLOCATION_ID = null;
                }
            }

            //Blast Injury - formerly Blast Explosion
            if (DropDownListBlastExplosion.SelectedValue != null) {
                if (DropDownListBlastExplosion.SelectedValue.Length > 0)
                {
                    polyTraumEntry.BLAST_EXPLOSION_INJRY_IND = Helpers.getNullableCharFromString(DropDownListBlastExplosion.SelectedValue);
                }
                else
                {
                    polyTraumEntry.BLAST_EXPLOSION_INJRY_IND = null;
                }
            }

            //Vehicle Injury
            if (DropDownListVechicleInjury.SelectedValue != null) {
                if (DropDownListVechicleInjury.SelectedValue.Length > 0) {
                    polyTraumEntry.VEHICLE_INJRY_IND = Helpers.getNullableCharFromString(DropDownListVechicleInjury.SelectedValue);
                }
                else
                {
                    polyTraumEntry.VEHICLE_INJRY_IND = null;
                }
            }
            //Bullet Injury
            if (DropDownListBulletInjury.SelectedValue != null) {
                if (DropDownListBulletInjury.SelectedValue.Length > 0) {
                    polyTraumEntry.BULLET_INJRY_IND = Helpers.getNullableCharFromString(DropDownListBulletInjury.SelectedValue);
                }
                else
                {
                    polyTraumEntry.BULLET_INJRY_IND = null;
                }
            }

            //Physical Assault Injury
            if (DropDownListPhysicalAssault.SelectedValue != null) {
                if (DropDownListPhysicalAssault.SelectedValue.Length > 0) {
                    polyTraumEntry.PHYS_ASSAULT_INJRY_IND = Helpers.getNullableCharFromString(DropDownListPhysicalAssault.SelectedValue);
                }
                else
                {
                    polyTraumEntry.PHYS_ASSAULT_INJRY_IND = null;
                }
            }

            //Other Injury
            if (DropDownListOtherInjury.SelectedValue != null) {
                if (DropDownListOtherInjury.SelectedValue.Length > 0) {
                    polyTraumEntry.OTHER_INJRY_IND = Helpers.getNullableCharFromString(DropDownListOtherInjury.SelectedValue);
                }
                else
                {
                    polyTraumEntry.OTHER_INJRY_IND = null;
                }
            }

            //Other Injury Description
            if (TextBoxOtherInjuryDescription.Text != null) {
                if (TextBoxOtherInjuryDescription.Text.Length > 0)
                {
                    polyTraumEntry.OTHER_INJRY_DSCR = TextBoxOtherInjuryDescription.Text;
                }
                else
                {
                    polyTraumEntry.OTHER_INJRY_DSCR = null;
                }
            }

            //Injury Details
            foreach (ListItem checkboxListInjury in CheckBoxListInjuryDetails.Items) {
                //for each item in the check box list check if it is an entity in TBI_INJURY_DETAILs
                TBI_INJURY_DETAIL existingInjury = (from e in polyTraumEntry.TBI_INJURY_DETAILs
                                                    where e.STD_TBIINJURYLIST_ID == Helpers.getIntFromString(checkboxListInjury.Value)
                                                    select e).FirstOrDefault();

                //check if the checkboxlist item was selected,  
                if (checkboxListInjury.Selected) {
                    //if the item is selected then it needs to be in TBI_INJURY_DETAILs
                    //if the entity exists, that signifies the item is already in TBI_INJURY_DETAILs therefore nothing needs to be done. 
                    if (existingInjury == null) {
                        TBI_INJURY_DETAIL newInjury = new TBI_INJURY_DETAIL();
                        newInjury.TBI_POLYTRAUMA_ID = polyTraumEntry.TBI_POLYTRAUMA_ID;
                        newInjury.STD_TBIINJURYLIST_ID = Helpers.getIntFromString(checkboxListInjury.Value);

                        polyTraumEntry.TBI_INJURY_DETAILs.Add(newInjury);
                    }
                } else {
                    //if the item is not selected, then it needs to be taken out of TBI_INJURY_DETAILs if it is in the list
                    if (existingInjury != null) {
                        existingInjury.SetAsDeleteOnSubmit();
                        //polyTraumEntry.TBI_INJURY_DETAILs.Remove(existingInjury);
                    }
                }
            }

            // Severity Level Index of TBI
            if (rblSeverityLevelIndexTBI.SelectedValue != null) {
                if (rblSeverityLevelIndexTBI.SelectedValue == "") {
                    polyTraumEntry.SEVERITY_LEVEL_INDEX_ID = null;
                } else {
                    polyTraumEntry.SEVERITY_LEVEL_INDEX_ID = Convert.ToInt32(rblSeverityLevelIndexTBI.SelectedValue);
                }
            }

            //Provider Location
            polyTraumEntry.PROVIDER_LOCATION = TextBoxFollowupProviderLocation.Text;

            //Follow Up Polytrauma Case Manager
            polyTraumEntry.PROVIDER_NAME = TextBoxProviderName.Text;

            //Provider Email
            polyTraumEntry.PROVIDER_EMAIL = TextBoxProviderEmail.Text;

            //Provider Phone
            polyTraumEntry.PROVIDER_PHONE = TextBoxProviderPhone.Text;

            //PolyTrauma VAMC
            if (DropDownListPolyTraumaVAMC.SelectedValue != null)
            {
                if (DropDownListPolyTraumaVAMC.SelectedValue.Length > 0)
                {
                    polyTraumEntry.POLYTRAUMA_CENTER_ID = Helpers.getIntFromString(DropDownListPolyTraumaVAMC.SelectedValue);
                }
                else
                {
                    polyTraumEntry.POLYTRAUMA_CENTER_ID = null;
                }
            }

            //Is Patient Emerging Consciousness
            polyTraumEntry.EMERGE_CONSCIOUSNESS_FLAG = (CheckBoxEmergingConsciousness.Checked == true ? 1 : 0);

            //Emerging Etiology
            if (DropDownListEmergingEtiology.SelectedValue != null)
            {
                if (DropDownListEmergingEtiology.SelectedValue.Length > 0)
                {
                    polyTraumEntry.STD_TBIEMERGINGETIOLOGY_ID = Helpers.getNullableIntFromString(DropDownListEmergingEtiology.SelectedValue);
                }
                else
                {
                    polyTraumEntry.STD_TBIEMERGINGETIOLOGY_ID = null;
                }
            }

            //Date Altered Consciousness
            if (TextBoxDateAlteredConsciousness.Text != null) {
                if (TextBoxDateAlteredConsciousness.Text.Length > 0)
                {
                    polyTraumEntry.ALTERED_CONSCIOUSNESS_DATE = Helpers.getNullableDateFromString(TextBoxDateAlteredConsciousness.Text);
                }
                else
                {
                    polyTraumEntry.ALTERED_CONSCIOUSNESS_DATE = null;
                }
            }

            //Date Patient Emerged
            if (PatientEmergedDate.DateValue != null) {
                if (PatientEmergedDate.DateValue.Length > 0)
                {
                    polyTraumEntry.EMERGE_CONSCIOUSNESS_DATE = Helpers.getNullableDateFromString(PatientEmergedDate.DateValue);
                }
                else
                {
                    polyTraumEntry.EMERGE_CONSCIOUSNESS_DATE = null;
                }
            }

            // JFK Coma Recovery Scale
            if (!String.IsNullOrEmpty(ddlJFKComaRecoveryScale.SelectedValue)) {
                polyTraumEntry.JFK_COMA_RECOVERY = Convert.ToInt32(ddlJFKComaRecoveryScale.SelectedValue);
            } else {
                polyTraumEntry.JFK_COMA_RECOVERY = null;
            }

            // Genito-Urinary Injuries
            // Yes = 1 (true) | No = 0 (false)
            if (!String.IsNullOrEmpty(rblGenitoUrinaryInjuries.SelectedValue)) {
                polyTraumEntry.GENITO_URINARY_INJURIES = (rblGenitoUrinaryInjuries.SelectedValue == "1") ? true : false;
            } else {
                polyTraumEntry.GENITO_URINARY_INJURIES = null;
            }

            //Admission FIM Code
            if (TextBoxAdmissionFIMScore.Text != null) {
                if (TextBoxAdmissionFIMScore.Text.Length > 0)
                {
                    polyTraumEntry.ADMISSION_FIM_CODE = TextBoxAdmissionFIMScore.Text;
                }
                else
                {
                    polyTraumEntry.ADMISSION_FIM_CODE = null;
                }
            }

            //Admission Date
            if (RehabAdmitDate.DateValue != null) {
                if (RehabAdmitDate.DateValue.Length > 0)
                {
                    polyTraumEntry.REHAB_ADMIT_DATE = Helpers.getNullableDateFromString(RehabAdmitDate.DateValue);
                }
                else
                {
                    polyTraumEntry.REHAB_ADMIT_DATE = null;
                }
            }

            //Days from Onset to Admission
            if (!String.IsNullOrEmpty(LabelDaysFromOnsetValue.Text)) {
                polyTraumEntry.DAYS_FROM_ONSET = Convert.ToInt32(LabelDaysFromOnsetValue.Text);
            } else {
                polyTraumEntry.DAYS_FROM_ONSET = null;
            }

            //FRG Code
            if (DropDownListFRGCode.SelectedValue != null)
            {
                if (DropDownListFRGCode.SelectedValue.Length > 0)
                {
                    polyTraumEntry.STD_TBI_FRG_ID = Helpers.getNullableIntFromString(DropDownListFRGCode.SelectedValue);
                }
                else
                {
                    polyTraumEntry.STD_TBI_FRG_ID = null;
                }
            }

            //TextBoxDaysOffUnit
            if (TextBoxDaysOffUnit.Text != null) {
                if (TextBoxDaysOffUnit.Text.Length > 0)
                {
                    polyTraumEntry.DAYS_OFF_UNIT_TOTAL = Helpers.getNullableIntFromString(TextBoxDaysOffUnit.Text);
                }
                else
                {
                    polyTraumEntry.DAYS_OFF_UNIT_TOTAL = null;
                }
            }

            //Discharge FIM Code
            if (TextBoxDischargeFIMScore.Text != null) {
                if (TextBoxDischargeFIMScore.Text.Length > 0)
                {
                    polyTraumEntry.DISCHARGE_FIM_CODE = TextBoxDischargeFIMScore.Text;
                }
                else
                {
                    polyTraumEntry.DISCHARGE_FIM_CODE = null;
                }
            }

            //Rehab Discharge Date
            if (RehabDischargeDate.DateValue != null) {
                if (RehabDischargeDate.DateValue.Length > 0)
                {
                    polyTraumEntry.REHAB_DISCHARGE_DATE = Helpers.getNullableDateFromString(RehabDischargeDate.DateValue);
                }
                else
                {
                    polyTraumEntry.REHAB_DISCHARGE_DATE = null;
                }
            }

            //Discharged To
            if (DropDownListRehabDischargedTo.Visible)
            {
                _intOriginalTbiDischargetoCode = polyTraumEntry.STD_TBIDISCHARGETO_ID;
                if (DropDownListRehabDischargedTo.SelectedValue != null)
                {
                    if (DropDownListRehabDischargedTo.SelectedValue.Length > 0)
                    {
                        polyTraumEntry.STD_TBIDISCHARGETO_ID =
                            Helpers.getNullableIntFromString(DropDownListRehabDischargedTo.SelectedValue);
                    }
                    else
                    {
                        polyTraumEntry.STD_TBIDISCHARGETO_ID = null;
                    }
                }
            }

            //Followup
            foreach (ListItem checkboxListFollowup in CheckBoxListFollowUps.Items) {

                //for each item in the check box list check if it is an entity in TBI_FOLLOWUPs
                TBI_FOLLOWUP existingFollowup = (from e in polyTraumEntry.TBI_FOLLOWUPs
                                                 where e.STD_TBIIFOLLOWUPLIST_ID == Helpers.getIntFromString(checkboxListFollowup.Value)
                                                 select e).FirstOrDefault();

                //check if the checkboxlist item was selected,  
                if (checkboxListFollowup.Selected) {
                    //if the item is selected then it needs to be in TBI_FOLLOWUPs
                    //if the entity exists, that signifies the item is already in TBI_FOLLOWUPs therefore nothing needs to be done. 
                    if (existingFollowup == null) {
                        TBI_FOLLOWUP newFollowup = new TBI_FOLLOWUP();
                        newFollowup.TBI_POLYTRAUMA_ID = polyTraumEntry.TBI_POLYTRAUMA_ID;
                        newFollowup.STD_TBIIFOLLOWUPLIST_ID = Helpers.getIntFromString(checkboxListFollowup.Value);

                        polyTraumEntry.TBI_FOLLOWUPs.Add(newFollowup);
                    }
                } else {
                    //if the item is not selected, then it needs to be taken out of TBI_FOLLOWUPs if it is in the list
                    if (existingFollowup != null) {
                        existingFollowup.SetAsDeleteOnSubmit();
                        //polyTraumEntry.TBI_FOLLOWUPs.Remove(existingFollowup);
                    }
                }
            }

            //Followup Site Description
            if (TextBoxFollowupSiteDescription.Text != null) {
                if (TextBoxFollowupSiteDescription.Text.Length > 0)
                {
                    polyTraumEntry.FOLLOWUP_SITE_DSCR = TextBoxFollowupSiteDescription.Text;
                }
                else
                {
                    polyTraumEntry.FOLLOWUP_SITE_DSCR = null;
                }
            }

            // New Area for PTRP-Related Information
            #region PTRP Information

            // PTRP Program
            if (!String.IsNullOrEmpty(rblPTRPProgram.SelectedValue)) {
                polyTraumEntry.PTRP_PROGRAM = rblPTRPProgram.SelectedValue;
            } else {
                polyTraumEntry.PTRP_PROGRAM = null;
            }

            // PTRP Preinjury Primary Person Living With
            if (!String.IsNullOrEmpty(ddlPTRPPreinjuryPrimaryPersonLivingWith.SelectedValue)) {
                polyTraumEntry.PREINJURY_PRIM_PERSON_LIVING_WITH_ID = Convert.ToInt32(ddlPTRPPreinjuryPrimaryPersonLivingWith.SelectedValue);
            } else {
                polyTraumEntry.PREINJURY_PRIM_PERSON_LIVING_WITH_ID = null;
            }

            // PTRP Preinjury Residence
            if (!String.IsNullOrEmpty(ddlPTRPPreinjuryResidence.SelectedValue)) {
                polyTraumEntry.PREINJURY_RESIDENCE_ID = Convert.ToInt32(ddlPTRPPreinjuryResidence.SelectedValue);
            } else {
                polyTraumEntry.PREINJURY_RESIDENCE_ID = null;
            }

            // PTRP Preinjury Primary Employment Status
            if (!String.IsNullOrEmpty(ddlPTRPPreinjuryPriEmployStatus.SelectedValue)) {
                polyTraumEntry.PRI_PREINJURY_EMPLOY_STATUS_ID = Convert.ToInt32(ddlPTRPPreinjuryPriEmployStatus.SelectedValue);
            } else {
                polyTraumEntry.PRI_PREINJURY_EMPLOY_STATUS_ID = null;
            }

            // PTRP Preinjury Secondary Employment Status
            if (!String.IsNullOrEmpty(ddlPTRPPreinjurySecEmployStatus.SelectedValue)) {
                polyTraumEntry.SEC_PREINJURY_EMPLOY_STATUS_ID = Convert.ToInt32(ddlPTRPPreinjurySecEmployStatus.SelectedValue);
            } else {
                polyTraumEntry.SEC_PREINJURY_EMPLOY_STATUS_ID = null;
            }

            #region Scoring

            // PTRP MPAI Abilities Initial
            if (!String.IsNullOrEmpty(txtMPAIAbilitiesInitial.Text)) {
                polyTraumEntry.MPAI_ABILITIES_INITIAL = Convert.ToInt32(txtMPAIAbilitiesInitial.Text);
            } else {
                polyTraumEntry.MPAI_ABILITIES_INITIAL = null;
            }

            // PTRP MPAI Abilities Discharge
            if (!String.IsNullOrEmpty(txtMPAIAbilitiesDischarge.Text)) {
                polyTraumEntry.MPAI_ABILITIES_DC = Convert.ToInt32(txtMPAIAbilitiesDischarge.Text);
            } else {
                polyTraumEntry.MPAI_ABILITIES_DC = null;
            }

            // PTRP MPAI Abilities Followup
            if (!String.IsNullOrEmpty(txtMPAIAbilitiesFollowup.Text)) {
                polyTraumEntry.MPAI_ABILITIES_FOLLOWUP = Convert.ToInt32(txtMPAIAbilitiesFollowup.Text);
            } else {
                polyTraumEntry.MPAI_ABILITIES_FOLLOWUP = null;
            }

            // PTRP MPAI Adjustment Initial
            if (!String.IsNullOrEmpty(txtMPAIAdjustmentInitial.Text)) {
                polyTraumEntry.MPAI_ADJUSTMENT_INITIAL = Convert.ToInt32(txtMPAIAdjustmentInitial.Text);
            } else {
                polyTraumEntry.MPAI_ADJUSTMENT_INITIAL = null;
            }

            // PTRP MPAI Adjustment Discharge
            if (!String.IsNullOrEmpty(txtMPAIAdjustmentDischarge.Text)) {
                polyTraumEntry.MPAI_ADJUSTMENT_DC = Convert.ToInt32(txtMPAIAdjustmentDischarge.Text);
            } else {
                polyTraumEntry.MPAI_ADJUSTMENT_DC = null;
            }

            // PTRP MPAI Adjustment FollowUp
            if (!String.IsNullOrEmpty(txtMPAIAdjustmentFollowUp.Text)) {
                polyTraumEntry.MPAI_ADJUSTMENT_FOLLOWUP = Convert.ToInt32(txtMPAIAdjustmentFollowUp.Text);
            } else {
                polyTraumEntry.MPAI_ADJUSTMENT_FOLLOWUP = null;
            }

            // PTRP MPAI Participation Initial
            if (!String.IsNullOrEmpty(txtMPAIParticipationInitial.Text)) {
                polyTraumEntry.MPAI_PARTICIPATION_INITIAL = Convert.ToInt32(txtMPAIParticipationInitial.Text);
            } else {
                polyTraumEntry.MPAI_PARTICIPATION_INITIAL = null;
            }

            // PTRP MPAI Participation Discharge
            if (!String.IsNullOrEmpty(txtMPAIParticipationDischarge.Text)) {
                polyTraumEntry.MPAI_PARTICIPATION_DC = Convert.ToInt32(txtMPAIParticipationDischarge.Text);
            } else {
                polyTraumEntry.MPAI_PARTICIPATION_DC = null;
            }

            // PTRP MPAI Participation FollowUp
            if (!String.IsNullOrEmpty(txtMPAIParticipationFollowUp.Text)) {
                polyTraumEntry.MPAI_PARTICIPATION_FOLLOWUP = Convert.ToInt32(txtMPAIParticipationFollowUp.Text);
            } else {
                polyTraumEntry.MPAI_PARTICIPATION_FOLLOWUP = null;
            }

            // PTRP MPAI Total Initial
            if (!String.IsNullOrEmpty(txtMPAITotalInitial.Text)) {
                polyTraumEntry.MPAI_TOTAL_INITIAL = Convert.ToInt32(txtMPAITotalInitial.Text);
            } else {
                polyTraumEntry.MPAI_TOTAL_INITIAL = null;
            }

            // PTRP MPAI Total Discharge
            if (!String.IsNullOrEmpty(txtMPAITotalDischarge.Text)) {
                polyTraumEntry.MPAI_TOTAL_DC = Convert.ToInt32(txtMPAITotalDischarge.Text);
            } else {
                polyTraumEntry.MPAI_TOTAL_DC = null;
            }

            // PTRP MPAI Total FollowUp
            if (!String.IsNullOrEmpty(txtMPAITotalFollowUp.Text)) {
                polyTraumEntry.MPAI_TOTAL_FOLLOWUP = Convert.ToInt32(txtMPAITotalFollowUp.Text);
            } else {
                polyTraumEntry.MPAI_TOTAL_FOLLOWUP = null;
            }

            // PTRP MPAI Question 26 Residence Admission
            if (!String.IsNullOrEmpty(rblMPAIQuestion26ResidenceAdmission.SelectedValue)) {
                polyTraumEntry.MPAI_Q26_ADMISSION = Convert.ToInt32(rblMPAIQuestion26ResidenceAdmission.SelectedValue);
            } else {
                polyTraumEntry.MPAI_Q26_ADMISSION = null;
            }

            // PTRP MPAI Question 26 Residence Discharge
            if (!String.IsNullOrEmpty(rblMPAIQuestion26ResidenceDischarge.SelectedValue)) {
                polyTraumEntry.MPAI_Q26_DC = Convert.ToInt32(rblMPAIQuestion26ResidenceDischarge.SelectedValue);
            } else {
                polyTraumEntry.MPAI_Q26_DC = null;
            }

            // PTRP MPAI Question 26 Residence FollowUp
            if (!String.IsNullOrEmpty(rblMPAIQuestion26ResidenceFollowUp.SelectedValue)) {
                polyTraumEntry.MPAI_Q26_FOLLOWUP = Convert.ToInt32(rblMPAIQuestion26ResidenceFollowUp.SelectedValue);
            } else {
                polyTraumEntry.MPAI_Q26_FOLLOWUP = null;
            }

            // PTRP Satisfaction With Life Initial
            if (!String.IsNullOrEmpty(txtSatisfactionWithLifeInitial.Text)) {
                polyTraumEntry.SATIS_W_LIFE_ADMISSION = Convert.ToInt32(txtSatisfactionWithLifeInitial.Text);
            } else {
                polyTraumEntry.SATIS_W_LIFE_ADMISSION = null;
            }

            // PTRP Satisfaction With Life Discharge
            if (!String.IsNullOrEmpty(txtSatisfactionWithLifeDischarge.Text)) {
                polyTraumEntry.SATIS_W_LIFE_DC = Convert.ToInt32(txtSatisfactionWithLifeDischarge.Text);
            } else {
                polyTraumEntry.SATIS_W_LIFE_DC = null;
            }

            // PTRP Satisfaction With Life FollowUp
            if (!String.IsNullOrEmpty(txtSatisfactionWithLifeFollowUp.Text)) {
                polyTraumEntry.SATIS_W_LIFE_FOLLOWUP = Convert.ToInt32(txtSatisfactionWithLifeFollowUp.Text);
            } else {
                polyTraumEntry.SATIS_W_LIFE_FOLLOWUP = null;
            }

            // PTRP PART FollowUp
            if (!String.IsNullOrEmpty(txtPARTFollowUp.Text)) {
                polyTraumEntry.PART_FOLLOWUP = Convert.ToInt32(txtPARTFollowUp.Text);
            } else {
                polyTraumEntry.PART_FOLLOWUP = null;
            }

            #endregion

            // PTRP Military Duty Status At Discharge -- Removed by stakeholder (2/26/14)
            //if (!String.IsNullOrEmpty(ddlMilitaryDutyStatusAtDischarge.SelectedValue)) {
            //    polyTraumEntry.DC_MILITARY_DUTY_STATUS_ID = Convert.ToInt32(ddlMilitaryDutyStatusAtDischarge.SelectedValue);
            //} else {
            //    polyTraumEntry.DC_MILITARY_DUTY_STATUS_ID = null;
            //}

            // PTRP Discharge Primary Person Living With
            if (!String.IsNullOrEmpty(ddlPTRPDCPrimaryPersonLivingWith.SelectedValue)) {
                polyTraumEntry.PRI_PERSON_LIVING_DC_ID = Convert.ToInt32(ddlPTRPDCPrimaryPersonLivingWith.SelectedValue);
            } else {
                polyTraumEntry.PRI_PERSON_LIVING_DC_ID = null;
            }

            // PTRP FollowUp Primary Person Living With
            if (!String.IsNullOrEmpty(ddlPTRPFollowUpPrimaryPersonLivingWith.SelectedValue)) {
                polyTraumEntry.PRI_PERSON_LIVING_FOLLOWUP_ID = Convert.ToInt32(ddlPTRPFollowUpPrimaryPersonLivingWith.SelectedValue);
            } else {
                polyTraumEntry.PRI_PERSON_LIVING_FOLLOWUP_ID = null;
            }

            // PTRP FollowUp Residence
            if (!String.IsNullOrEmpty(ddlPTRPFollowUpResidence.SelectedValue)) {
                polyTraumEntry.FOLLOWUP_RESIDENCE_ID = Convert.ToInt32(ddlPTRPFollowUpResidence.SelectedValue);
            } else {
                polyTraumEntry.FOLLOWUP_RESIDENCE_ID = null;
            }

            // PTRP Discharge Residence
            if (!String.IsNullOrEmpty(ddlPTRPDCResidence.SelectedValue)) {
                polyTraumEntry.DC_RESIDENCE_ID = Convert.ToInt32(ddlPTRPDCResidence.SelectedValue);
            } else {
                polyTraumEntry.DC_RESIDENCE_ID = null;
            }

            // PTRP Discharge Primary Employment Status
            if (!String.IsNullOrEmpty(ddlPTRPDCPriEmployStatus.SelectedValue)) {
                polyTraumEntry.PRI_DC_EMPLOY_STATUS_ID = Convert.ToInt32(ddlPTRPDCPriEmployStatus.SelectedValue);
            } else {
                polyTraumEntry.PRI_DC_EMPLOY_STATUS_ID = null;
            }

            // PTRP Discharge Secondary Employment Status
            if (!String.IsNullOrEmpty(ddlPTRPDCSecEmployStatus.SelectedValue)) {
                polyTraumEntry.SEC_DC_EMPLOY_STATUS_ID = Convert.ToInt32(ddlPTRPDCSecEmployStatus.SelectedValue);
            } else {
                polyTraumEntry.SEC_DC_EMPLOY_STATUS_ID = null;
            }

            // PTRP FollowUp Primary Employment Status
            if (!String.IsNullOrEmpty(ddlPTRPFollowUpPriEmployStatus.SelectedValue)) {
                polyTraumEntry.PRI_FOLLOWUP_EMPLOY_STATUS_ID = Convert.ToInt32(ddlPTRPFollowUpPriEmployStatus.SelectedValue);
            } else {
                polyTraumEntry.PRI_FOLLOWUP_EMPLOY_STATUS_ID = null;
            }

            // PTRP FollowUp Secondary Employment Status
            if (!String.IsNullOrEmpty(ddlPTRPFollowUpSecEmployStatus.SelectedValue)) {
                polyTraumEntry.SEC_FOLLOWUP_EMPLOY_STATUS_ID = Convert.ToInt32(ddlPTRPFollowUpSecEmployStatus.SelectedValue);
            } else {
                polyTraumEntry.SEC_FOLLOWUP_EMPLOY_STATUS_ID = null;
            }

            #endregion


            //PRC Follow up Date
            if (PRCFollowupDate.DateValue != null)
            {
                if (PRCFollowupDate.DateValue.Length > 0)
                {
                    polyTraumEntry.PRC_FOLLOWUP_DATE = Helpers.getNullableDateFromString(PRCFollowupDate.DateValue);
                }
                else
                {
                    polyTraumEntry.PRC_FOLLOWUP_DATE = null;
                }
            }

            //PTRP Follow up Date
            if (PTRPFollowupDate.DateValue != null)
            {
                if (PTRPFollowupDate.DateValue.Length > 0)
                {
                    polyTraumEntry.PTRP_FOLLOWUP_DATE = Helpers.getNullableDateFromString(PTRPFollowupDate.DateValue);
                }
                else
                {
                    polyTraumEntry.PTRP_FOLLOWUP_DATE = null;
                }
            }

            //PTRP Admission Date
            if (PTRPAdmissionDate.DateValue != null)
            {
                if (PTRPAdmissionDate.DateValue.Length > 0)
                {
                    polyTraumEntry.PTRP_ADMIT_DATE = Helpers.getNullableDateFromString(PTRPAdmissionDate.DateValue);
                }
                else
                {
                    polyTraumEntry.PTRP_ADMIT_DATE = null;
                }
            }

            //PTRP Discharge Date
            if (PTRPDischargeDate.DateValue != null)
            {
                if (PTRPDischargeDate.DateValue.Length > 0)
                {
                    polyTraumEntry.PTRP_DISCHARGE_DATE = Helpers.getNullableDateFromString(PTRPDischargeDate.DateValue);
                }
                else
                {
                    polyTraumEntry.PTRP_DISCHARGE_DATE = null;
                }
            }

            //Set Range Validators for Date Of Birth and Date Of Death
            SetDatesRangeValidators(false);
        } catch (Exception _ex) {
            Logging.WriteLogToFile("PolyTraumaEntry LoadObjectFromControls exception: " + _ex.ToString());
            //_tbiexception.HandleTBIException(_ex, "PolyTraumaEntry", "1000033", "LoadObjectFromControls()");
        }
    }

    private void SetDatesRangeValidators(bool loadControlsFromObject) {
        //Load Controls From Object
        if (loadControlsFromObject) {
            RangeValidatorTextBoxDateOfBirth.MinimumValue = DateTime.MinValue.ToShortDateString();
            RangeValidatorTextBoxDateOfBirth.MaximumValue = DateTime.Now.ToShortDateString();
        }
            //Load Object From Controls 
        else {
            RangeValidatorTextBoxDateOfBirth.MinimumValue = DateTime.MinValue.ToShortDateString();
            RangeValidatorTextBoxDateOfBirth.MaximumValue = DateTime.Now.ToShortDateString();
        }
    }

    private void PopulateDropDowns()
    {
        if (DropDownListGender.Items.Count == 1)
        {
            DropDownListGender.DataSourceID = "ObjectDataSourceGender";
            DropDownListGender.DataBind();
        }

        if (DropDownListMaritalStatus.Items.Count == 1)
        {
            DropDownListMaritalStatus.DataSourceID = "ObjectDataSourceMaritalStatus";
            DropDownListMaritalStatus.DataBind();
        }

        if (DropDownListRace.Items.Count == 1)
        {
            DropDownListRace.DataSourceID = "ObjectDataSourceRace";
            DropDownListRace.DataBind();
        }

        if (DropDownListEthnicity.Items.Count == 1)
        {
            DropDownListEthnicity.DataSourceID = "ObjectDataSourceEthnicity";
            DropDownListEthnicity.DataBind();
        }

        if (DropDownListHomeVAMC.Items.Count == 1)
        {
            DropDownListHomeVAMC.DataSourceID = "ObjectDataSourceVAMC";
            DropDownListHomeVAMC.DataBind();
        }

        if (DropDownListMilitartServiceBranch.Items.Count == 1)
        {
            DropDownListMilitartServiceBranch.DataSourceID = "ObjectDataSourceMilitaryServiceBranch";
            DropDownListMilitartServiceBranch.DataBind();
        }

        if (DropDownListMilitaryServiceStatus.Items.Count == 1)
        {
            DropDownListMilitaryServiceStatus.DataSourceID = "ObjectDataSourceMilitaryServiceStatus";
            DropDownListMilitaryServiceStatus.DataBind();
        }

        if (DropDownListDischargeStatus.Items.Count == 1)
        {
            DropDownListDischargeStatus.DataSourceID = "ObjectDataSourceDischargeStatus";
            DropDownListDischargeStatus.DataBind();
        }

        if (DropDownListPolyTraumaVAMC.Items.Count == 1)
        {
            DropDownListPolyTraumaVAMC.DataSourceID = "ObjectDataSourcePolyTraumaVAMC";
            DropDownListPolyTraumaVAMC.DataBind();
        }

        if (DropDownListTBIFacilitySource.Items.Count == 1)
        {
            DropDownListTBIFacilitySource.DataSourceID = "ObjectDataSourceTBIFacilitySource";
            DropDownListTBIFacilitySource.DataBind();
        }

        if (DropDownListCombatLocation.Items.Count == 1)
        {
            DropDownListCombatLocation.DataSourceID = "ObjectDataSourceCombatLocation";
            DropDownListCombatLocation.DataBind();
        }

        if (DropDownListEmergingEtiology.Items.Count == 1)
        {
            DropDownListEmergingEtiology.DataSourceID = "ObjectDataSourceEmergingEtiology";
            DropDownListEmergingEtiology.DataBind();
        }

        if (DropDownListFRGCode.Items.Count == 1)
        {
            DropDownListFRGCode.DataSourceID = "ObjectDataSourceFRG";
            DropDownListFRGCode.DataBind();
        }

        if (DropDownListRehabDischargedTo.Items.Count == 1)
        {
            DropDownListRehabDischargedTo.DataSourceID = "ObjectDataSourceRehabDischargeTo";
            DropDownListRehabDischargedTo.DataBind();
        }

        if (ddlPTRPPreinjuryPrimaryPersonLivingWith.Items.Count == 1)
        {
            ddlPTRPPreinjuryPrimaryPersonLivingWith.DataSourceID = "ObjectDataSourcePTRPPreinjuryPrimaryPersonLivingWith";
            ddlPTRPPreinjuryPrimaryPersonLivingWith.DataBind();
        }

        if (ddlPTRPPreinjuryResidence.Items.Count == 1)
        {
            ddlPTRPPreinjuryResidence.DataSourceID = "ObjectDataSourceRehabDischargeTo";
            ddlPTRPPreinjuryResidence.DataBind();
        }

        if (ddlPTRPPreinjuryPriEmployStatus.Items.Count == 1)
        {
            ddlPTRPPreinjuryPriEmployStatus.DataSourceID = "ObjectDataSourceEmploymentStatus";
            ddlPTRPPreinjuryPriEmployStatus.DataBind();
        }

        if (ddlPTRPPreinjurySecEmployStatus.Items.Count == 1)
        {
            ddlPTRPPreinjurySecEmployStatus.DataSourceID = "ObjectDataSourceEmploymentStatus";
            ddlPTRPPreinjurySecEmployStatus.DataBind();
        }

        if (ddlPTRPDCPrimaryPersonLivingWith.Items.Count == 1)
        {
            ddlPTRPDCPrimaryPersonLivingWith.DataSourceID = "ObjectDataSourcePTRPPreinjuryPrimaryPersonLivingWith";
            ddlPTRPDCPrimaryPersonLivingWith.DataBind();
        }

        if (ddlPTRPDCResidence.Items.Count == 1)
        {
            ddlPTRPDCResidence.DataSourceID = "ObjectDataSourceRehabDischargeToPTRP";
            ddlPTRPDCResidence.DataBind();
        }

        if (ddlPTRPFollowUpPrimaryPersonLivingWith.Items.Count == 1)
        {
            ddlPTRPFollowUpPrimaryPersonLivingWith.DataSourceID = "ObjectDataSourcePTRPPreinjuryPrimaryPersonLivingWith";
            ddlPTRPFollowUpPrimaryPersonLivingWith.DataBind();
        }

        if (ddlPTRPFollowUpResidence.Items.Count == 1)
        {
            ddlPTRPFollowUpResidence.DataSourceID = "ObjectDataSourceRehabDischargeToPTRP";
            ddlPTRPFollowUpResidence.DataBind();
        }

        if (ddlPTRPDCPriEmployStatus.Items.Count == 1)
        {
            ddlPTRPDCPriEmployStatus.DataSourceID = "ObjectDataSourceEmploymentStatus";
            ddlPTRPDCPriEmployStatus.DataBind();
        }

        if (ddlPTRPDCSecEmployStatus.Items.Count == 1)
        {
            ddlPTRPDCSecEmployStatus.DataSourceID = "ObjectDataSourceEmploymentStatus";
            ddlPTRPDCSecEmployStatus.DataBind();
        }

        if (ddlPTRPFollowUpPriEmployStatus.Items.Count == 1)
        {
            ddlPTRPFollowUpPriEmployStatus.DataSourceID = "ObjectDataSourceEmploymentStatus";
            ddlPTRPFollowUpPriEmployStatus.DataBind();
        }

        if (ddlPTRPFollowUpSecEmployStatus.Items.Count == 1)
        {
            ddlPTRPFollowUpSecEmployStatus.DataSourceID = "ObjectDataSourceEmploymentStatus";
            ddlPTRPFollowUpSecEmployStatus.DataBind();
        }

        if (rblPolytraumaEntryType.Items.Count == 0)
        {
            rblPolytraumaEntryType.DataSourceID = "ObjectDataSourcePolytraumaEntryType";
            rblPolytraumaEntryType.DataBind();
        }

        if (rblSeverityLevelIndexTBI.Items.Count == 0)
        {
            rblSeverityLevelIndexTBI.DataSourceID = "ObjectDataSourceSeverityLevelIndexTBI";
            rblSeverityLevelIndexTBI.DataBind();
        }

        if (CheckBoxListInjuryDetails.Items.Count == 0)
        {
            CheckBoxListInjuryDetails.DataSourceID = "ObjectDataSourceInjuryDetailList";
            CheckBoxListInjuryDetails.DataBind();
        }

        if (CheckBoxListFollowUps.Items.Count == 0)
        {
            CheckBoxListFollowUps.DataSourceID = "ObjectDataSourceFollowUpList";
            CheckBoxListFollowUps.DataBind();
        }
    }

    private void TransferPatientInformationToNewPolyTraumaEntry(PATIENT patientEntry) {
        try {
            //Patient ID
            polyTraumEntry.PATIENT = patientEntry;
            if (patientEntry.PATIENT_ID != null) {
                HiddenFieldPatientID.Value = patientEntry.PATIENT_ID.ToString();
            }

            if (patientEntry.Snum != null) {
                //SSN
                polyTraumEntry.Snum = patientEntry.Snum;
            }

            if (patientEntry.FIRST_NAME != null) {
                //First Name
                polyTraumEntry.FIRST_NAME = patientEntry.FIRST_NAME;
            }

            if (patientEntry.MIDDLE_NAME != null) {
                //Middle Name
                polyTraumEntry.MIDDLE_NAME = patientEntry.MIDDLE_NAME;
            }

            if (patientEntry.LAST_NAME != null) {
                //Last Name
                polyTraumEntry.LAST_NAME = patientEntry.LAST_NAME;
            }

            if (patientEntry.BIRTH_DATE != null) {
                //Date of Birth
                polyTraumEntry.BIRTH_DATE = patientEntry.BIRTH_DATE;
            }

            if (patientEntry.STD_GENDER_ID != null) {
                //Gender
                polyTraumEntry.STD_GENDER_ID = patientEntry.STD_GENDER_ID;
            }

            if (patientEntry.STD_MARITALSTATUS_ID != null) {
                //Marital Status
                polyTraumEntry.STD_MARITALSTATUS_ID = patientEntry.STD_MARITALSTATUS_ID;
            }

            if (patientEntry.STD_RACE_ID != null) {
                //Race
                polyTraumEntry.STD_RACE_ID = patientEntry.STD_RACE_ID;
            }

            if (patientEntry.STD_ETHNICITY_ID != null) {
                //Ethnicity
                polyTraumEntry.STD_ETHNICITY_ID = patientEntry.STD_ETHNICITY_ID;
            }

            if (patientEntry.DEATH_DATE != null) {
                //Date of Death
                polyTraumEntry.DEATH_DATE = patientEntry.DEATH_DATE;
            }

            if (patientEntry.ADDRESS_LINE1 != null) {
                //Address
                polyTraumEntry.ADDRESS_LINE1 = patientEntry.ADDRESS_LINE1;
            }

            if (patientEntry.ADDRESS_LINE2 != null) {
                //Address Line 2
                polyTraumEntry.ADDRESS_LINE2 = patientEntry.ADDRESS_LINE2;
            }

            if (patientEntry.ADDRESS_LINE3 != null) {
                //Adrress Line3
                polyTraumEntry.ADDRESS_LINE3 = patientEntry.ADDRESS_LINE3;
            }

            if (patientEntry.CITY != null) {
                //City
                polyTraumEntry.CITY = patientEntry.CITY;
            }

            if (patientEntry.STATE != null) {
                //State
                polyTraumEntry.STATE = patientEntry.STATE;
            }

            if (patientEntry.COUNTY != null) {
                //County
                polyTraumEntry.COUNTY = patientEntry.COUNTY;
            }

            if (patientEntry.COUNTRY != null) {
                //Country
                polyTraumEntry.COUNTRY = patientEntry.COUNTRY;
            }

            if (patientEntry.POSTAL_CODE != null) {
                //Postal Code
                polyTraumEntry.POSTAL_CODE = patientEntry.POSTAL_CODE;
            }

            if (patientEntry.HOME_PHONE != null) {
                //Home Phone
                polyTraumEntry.HOME_PHONE = patientEntry.HOME_PHONE;
            }

            if (patientEntry.EMAIL_ADDRESS != null) {
                //Email Address
                polyTraumEntry.EMAIL_ADDRESS = patientEntry.EMAIL_ADDRESS;
            }

            if (patientEntry.STD_INSTITUTION_ID != null) {
                //Home VAMC
                polyTraumEntry.PATIENT_HOME_VAMC_ID = Helpers.getIntFromString(patientEntry.STD_INSTITUTION_ID.ToString());
            }

            if (patientEntry.STD_SERVICEBRANCH_ID != null) {
                //Military Service Branch
                polyTraumEntry.STD_SERVICEBRANCH_ID = patientEntry.STD_SERVICEBRANCH_ID;
            }
        }
        catch (Exception _ex)
        {
            Logging.WriteLogToFile("PolyTraumaEntry TransferPatientInformationToNewPolyTraumaEntry exception: " + _ex.ToString());
            //_tbiexception.HandleTBIException(_ex, "PolyTraumaEntry", "1000033", "LoadObjectFromControls()");
        }
    }

    #endregion
}
